/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.impl.engine;

import java.util.Collection;

import javax.lang.model.element.ExecutableElement;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;

/**
 * Message aimed at specifying to an execution its next {@link ExecutableElement}. 
 * 
 * @author mjambert
 *
 */
public final class ExecutionMessage {

	private final SCAComponent sender;
	private final Collection<? extends Node> nextExecutableElements;
	
	public ExecutionMessage(SCAComponent sender, 
			Collection<? extends Node> nextExecutableElements) {
		this.sender = sender;
		assert nextExecutableElements != null;
		this.nextExecutableElements = nextExecutableElements;
	}
	
	public final SCAComponent getSender() {
		return sender;
	}
	
	public final Collection<? extends Node> getNextExecutableElements() {
		return nextExecutableElements;
	}
}
