/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easyviper.core.api.soa.message.Body;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Header;
import com.ebmwebsourcing.easyviper.model.Texternalmessage;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ExternalMessageImpl<T> extends AbstractSchemaElementImpl<Texternalmessage> implements
ExternalMessage<T> {

	//TODO replace Content by Body
	private Body<T> body;

	private Header header = new HeaderImpl();

	public ExternalMessageImpl() {
		super();
		this.model = new Texternalmessage();
	}

	public ExternalMessageImpl(Texternalmessage model, AbstractSchemaElementImpl<?> parent) {
		super(model, parent);

	}

	public T getContent() {
		return (T) this.model.getContent();
	}


	public String getEndpoint() {
		return this.model.getEndpoint();
	}


	public String getOperationName() {
		return this.model.getOperation(); 
	}


	public QName getQName() {
		return this.model.getQname();
	}


	public QName getService() {
		return this.model.getService();
	}


	public void setContent(T content) {
		this.model.setContent(content);

	}


	public void setEndpoint(String arg0) {
		this.model.setEndpoint(arg0);

	}


	public void setOperationName(String arg0) {
		this.model.setOperation(arg0);

	}


	public void setQName(QName arg0) {
		this.model.setQname(arg0);

	}


	public void setService(QName arg0) {
		this.model.setService(arg0);
	}

	public Body<T> getBody(){
		return this.body;
	}

	public void setBody(Body<T> body){
		this.body = body;
	}

	public Header getHeader(){
		return this.header;
	}

	public void setHeader(Header header){
		this.header = header;
	}

	@Override
	public String toString() {
		String res = null;
		if(this.getContent() != null && this.getContent() instanceof Element) {
			final XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
			res = outputter.outputString((Element)this.getContent());
		} else if(this.getContent() != null && this.getContent() instanceof String) {
		    res = (String) this.getContent();
		}else{
			res = super.toString();
		}

		return res; 
	}
}
