/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={AssignBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class AssignBehaviourImpl
extends AbstractBehaviourImpl
implements AssignBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(AssignBehaviourImpl.class.getName());
    @Property(name="assignements", required=true)
    private List<AssignementExpression> assignements = new ArrayList<AssignementExpression>();

    public String toString() {
        return "Assign";
    }

    public void affect() throws CoreException {
        if (this.assignements != null) {
            for (AssignementExpression assignement : this.assignements) {
                if (assignement == null || assignement.getLeft() == null) {
                    throw new CoreException("The left assignement is null");
                }
                Assigner assigner = this.getNode().getExecution().getParentScope().getProcess().getAssigner();
                if (assigner == null) {
                    throw new CoreException("Error: the assigner cannot be null");
                }
                this.log.finest("set " + assignement.getRight() + " in " + assignement.getLeft());
                assigner.affect(this.getNode().getExecution().getParentScope(), assignement.getLeft(), assignement.getRight());
            }
        }
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    protected void executeOnEnded() throws CoreException {
    }

    protected void executeOnInactive() throws CoreException {
        this.log.finest("start assign behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        this.affect();
        this.log.finest("end of assign behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }

    protected void executeOnStarted() throws CoreException {
    }
}

