/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine;

import javax.xml.namespace.QName;

import org.objectweb.fractal.fraclet.annotations.Interface;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.ServiceManager;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Interface(name = "service")
public interface Engine extends Element {

	void setInternalMessageType(Class clazz);

	Class getInternalMessageType();

	Process createNewEmptyProcessInstance(QName uniqueProcessName)
			throws CoreException;

	void accept(InternalMessage<?> internalMessage, ExternalContext context)
			throws CoreException;

	void sendTo(InternalMessage<?> message, Endpoint endpoint,
			ExternalContext context) throws CoreException;

	InternalMessage<?> sendSyncTo(InternalMessage<?> request,
			Endpoint endpoint, ExternalContext context) throws CoreException;

	void flushMessagesInRegistry() throws CoreException;

	ProcessInstanceRegistry getProcessInstanceRegistry();

	void deleteProcess(Process process) throws CoreException;
	
	ServiceManager getServiceManager();
	
	Core getCore() throws CoreException;
	
	ClassLoader getClassLoader();

}
