/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.factory;

import java.util.HashMap;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractFactoryImpl {

	public static final String DEFAULT_FACTORY_NAME = "core";
	

	private static Logger log = Logger.getLogger(AbstractFactoryImpl.class
			.getName());

	private static Core core;
	
	@SuppressWarnings("unchecked")
	protected Core createCore(final String name, final ConfigurationEngine configuration, Class<? extends Core> coreClass)
			throws CoreException {
		core = null;
		
		boolean explorer = false;
		if(configuration != null && configuration.getExplorer() != null) {
			explorer = configuration.getExplorer();
		}
		final Component coreComponent = this.createCoreComposite(explorer, coreClass);
		try {
			FractalHelper.getFractalHelper().startComponent(coreComponent);

			core = (Core) coreComponent.getFcInterface("/content");
			core.init(coreComponent);

			if (name != null) {
				FractalHelper.getFractalHelper().changeName(coreComponent,
						name);
			}

			core = (Core) coreComponent.getFcInterface("/content");
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		AbstractFactoryImpl.log.finest("core created and started");
		return core;
	}

	/**
	 * Initialize core composite
	 * 
	 * @throws CoreException
	 * 
	 */
	private Component createCoreComposite(boolean explorer, Class<? extends Core> coreClass)
			throws CoreException {
		Component coreComponent = null;

		if (!explorer) {
			coreComponent = FractalHelper.getFractalHelper()
					.createNewComponent(coreClass.getName(), null);
		} else {
			final Component explorerComponent = FractalHelper.getFractalHelper()
					.createNewComponent(FractalHelper.CORE_EXPLORER_COMPOSITE,
							new HashMap<Object, Object>());

			FractalHelper.getFractalHelper().startComponent(explorerComponent);
			final Component explorerComp = FractalHelper.getFractalHelper()
					.getComponents(explorerComponent).get(0);

			final Component myExplorerComp = FractalHelper.getFractalHelper()
					.getComponents(explorerComp).get(1);

			coreComponent = FractalHelper.getFractalHelper().getComponents(
					myExplorerComp).get(1);
		}
		FractalHelper.getFractalHelper().changeName(coreComponent,
				AbstractFactoryImpl.DEFAULT_FACTORY_NAME);

		return coreComponent;
	}

	
	public static Core getCore() {
		return core;
	}
}
