/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api;

import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class CoreException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String name = this.getClass().getName();
	
	private Message fault = null;
	
	/**
	 * 
	 */
	public CoreException() {
		super();
	}

	/**
	 * @param message
	 */
	public CoreException(final String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public CoreException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 */
	public CoreException(final Throwable cause) {
		super(cause);
	}

	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof CoreException)) {
			return false;
		}
		CoreException other = (CoreException) obj;
		if (name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!name.equals(other.name)) {
			return false;
		}
		return true;
	}
	
	public Message getFault() {
		return fault;
	}

	public void setFault(Message fault) {
		this.fault = fault;
	}
}
