/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import java.util.Map;

import javax.xml.namespace.QName;

import org.objectweb.fractal.fraclet.annotations.Interface;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Element;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Interface(name = "service")
public interface Behaviour extends Element {

	public enum State {
		ACTIVITY_INACTIVE, ACTIVITY_STARTED, ACTIVITY_ENDED
	};

	Map<String, Object> getInitializationContext() throws CoreException;

	void setInitializationContext(Map<String, Object> context)
			throws CoreException;

	void execute() throws CoreException;

	Node getNode();

	State getState();

	void setState(State state);
	
	QName getQName() throws CoreException;
	
	void setQName(QName name) throws CoreException;
	
	
}
