/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.model.registry.definition;

import static org.objectweb.fractal.fraclet.types.Step.CREATE;
import static org.objectweb.fractal.fraclet.types.Step.DESTROY;
import static org.objectweb.fractal.fraclet.types.Step.START;
import static org.objectweb.fractal.fraclet.types.Step.STOP;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.tools.ProcessForker;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component
@Membrane(controller = "primitive")
public abstract class AbstractProcessDefinitionRegistry<Def extends ProcessDefinition>
implements ProcessDefinitionRegistry<Def> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger
	.getLogger(AbstractProcessDefinitionRegistry.class.getName());


	/**
	 * The Registry of Process Definitions as a Map
	 */
	protected Map<ProcessKey, Def> registry = new HashMap<ProcessKey, Def>();

	/**
	 * The StaticAnalysis to set after creating the registry
	 */
	private StaticAnalysis staticAnalysis;

	/**
	 * The StaticAnalysisPrinter to set after creating the staticAnalysis
	 */
	private StaticAnalysisPrinter staticAnalysisPrinter;

	/**
	 * The Fractal component
	 */
	@Controller
	private Component component;

	/**
	 * Create the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = CREATE)
	public void create() throws CoreException {
		AbstractProcessDefinitionRegistry.log.fine("Fractal registry created: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	public void init(final Component fractalNode) throws CoreException {
		this.component = fractalNode;
		AbstractProcessDefinitionRegistry.log
		.fine("Fractal registry initiated: "
				+ FractalHelper.getFractalHelper().getName(
						this.component));
	}

	/**
	 * Start the NodeImpl behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = START)
	public void start() throws CoreException {
		AbstractProcessDefinitionRegistry.log.fine("Fractal registry started: "
				+ this.getName());
	}

	/**
	 * Stop the NodeImpl behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = STOP)
	public void stop() throws CoreException {
		AbstractProcessDefinitionRegistry.log.finest("sender " + this.getName() + " is stopping... ");

		AbstractProcessDefinitionRegistry.log.finest("sender stopped: " + this.getName());
	}

	/**
	 * Destroy the NodeImpl behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = DESTROY)
	public void destroy() throws CoreException {
		AbstractProcessDefinitionRegistry.log
		.fine("Fractal registry destroyed: " + this.getName());

	}

	public String getName() throws CoreException {
		return FractalHelper.getFractalHelper().getName(this.component);
	}

	public void setName(final String name) throws CoreException {
		if (name != null) {
			FractalHelper.getFractalHelper().changeName(this.component, name);
		}
	}

	public Component getComponent() {
		return this.component;
	}

	public Model getModel() throws CoreException {
		Model res = null;
		try {
			final Component modelComp = FractalHelper.getFractalHelper().getParent(
					this.getComponent());
			res = (Model) modelComp.getFcInterface("service");
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}


	public StaticAnalysis getStaticAnalysis() {
		return staticAnalysis;
	}

	public void setStaticAnalysis(StaticAnalysis staticAnalysis) {
		this.staticAnalysis = staticAnalysis;
	}

	public StaticAnalysisPrinter getStaticAnalysisPrinter() {
		return staticAnalysisPrinter;
	}

	public void setStaticAnalysisPrinter(StaticAnalysisPrinter staticAnalysisPrinter) {
		this.staticAnalysisPrinter = staticAnalysisPrinter;
	}

	public synchronized ProcessDefinition storeProcessDefinition(final URI uri,
			final ProcessContextDefinition context) throws CoreException {

		Def processDefinition = null;
		processDefinition = (Def) this.getModel().getCompiler().validate(uri);
		AbstractProcessDefinitionRegistry.log.finest("Number of process instances : "
				+ this.getModel().getCore().getEngine()
				.getProcessInstanceRegistry().getProcessInstances()
				.size());
		//TODO Check StaticAnalysis
		if(this.getStaticAnalysis()!=null && this.getStaticAnalysisPrinter() != null){
			if (this.getStaticAnalysis().getErrors().size() > 0) {
				final String msg = this.getStaticAnalysisPrinter().printAll(
						this.getStaticAnalysis().getErrors(),
						this.getStaticAnalysis().getWarnings(),
						this.getStaticAnalysis().getInfos());
				throw new CoreException("Compilation Error: " + msg,
						this.getStaticAnalysis().getErrors().get(0)
						.getError());
			} else if (this.getStaticAnalysis().getWarnings().size() > 0) {
				final String msg = this.getStaticAnalysisPrinter().printAll(
						this.getStaticAnalysis().getErrors(),
						this.getStaticAnalysis().getWarnings(),
						this.getStaticAnalysis().getInfos());
				AbstractProcessDefinitionRegistry.log.finest("Compilation warning: " + msg);
			}

			// create Keys
			List<ProcessKey> keys = null;
			keys = this.createKeys(processDefinition);
			if ((keys == null) || (keys.size() == 0)) {
				throw new CoreException("The keys cannot be null");
			}


			String logMsg = "\nList of key :\n";
			for (final ProcessKey key : keys) {
				logMsg = logMsg + key;
				this.registry.put(key, processDefinition);
			}
			AbstractProcessDefinitionRegistry.log.finest(logMsg);


			if (context.getPoolSize() > 0) {
				final Process processInstance = this.getModel().getCompiler().compile(processDefinition);
				
				processInstance.run();
				AbstractProcessDefinitionRegistry.log.info("First process started");

				// Pool of instances
				int cpt = 1;
				while (cpt < context.getPoolSize()) {
					ProcessForker forker = new ProcessForker(cpt,
							processDefinition, this, keys);
					forker.start();
					AbstractProcessDefinitionRegistry.log.finest("process number" + cpt
							+ " is going to be stored ...");
					cpt++;
				}

			} 

		}else{
			AbstractProcessDefinitionRegistry.log.severe("StaticAnalysis and StaticAnalysisPrinter MUST be set for this definition model.");
		}
		return processDefinition;
	}

	public void unStoreProcessDefinition(final URI uri,
			final boolean forceUninstall) throws CoreException {

		Def processDefinition = null;

		processDefinition = (Def) this.getModel().getCompiler().validate(uri);

		// create Keys
		List<ProcessKey> keys = null;
		keys = this.createKeys(processDefinition);
		if (keys != null) {
			for (final ProcessKey key : keys) {
				this.removeProcessDefinition(key, forceUninstall);
			}
		}
	}

	abstract public List<ProcessKey> createKeys(ProcessDefinition processDefinition) throws CoreException;

	abstract public <D extends ProcessDefinition > boolean isCreateInstance(D def, InternalMessage<?> mess);

}
