package com.ebmwebsourcing.easyviper.core.api.engine.behaviour.nonfunctionnal;

import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;


@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "abstract_non_functional_service", signature = NonFunctionnalBehaviour.class))
@Membrane(controller = "primitive")
public abstract class AbstractNonFunctionnalBehaviourImpl extends AbstractBehaviourImpl
		implements NonFunctionnalBehaviour {


	private static final long serialVersionUID = 1L;
	
	
	private Logger log = Logger.getLogger(AbstractNonFunctionnalBehaviourImpl.class.getName());

	@Override
	public ExecutableElement getExecutableElement() {
		return (ExecutableElement) getTransition();
	}

	
	public void run(){
		try {
			execute();
		} catch (CoreException e) {
			this.log.severe("Error in execution of non functional behaviour ... " + e.getMessage());
			
		}
		
	}
	public abstract Transition getTransition();

}
