/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.model.registry.definition;

import java.net.URI;
import java.util.List;

import org.objectweb.fractal.fraclet.annotations.Interface;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Element;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.tools.ProcessForker;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 * @author jlesbegueries
 */
@Interface(name = "service")
public interface ProcessDefinitionRegistry<Def extends ProcessDefinition>
extends Element {

	ProcessDefinition storeProcessDefinition(URI bpeluri, ProcessContextDefinition context) throws CoreException;

	void unStoreProcessDefinition(final URI uri, boolean forceUninstall) throws CoreException;

	Def getProcessDefinition(ProcessKey name);

	List<Def> getAllProcessDefinitions();

	Def removeProcessDefinition(ProcessKey name, boolean forceUninstall) throws CoreException;

	List<ProcessKey> createKeys(ProcessDefinition processDefinition) throws CoreException;
	
	StaticAnalysis getStaticAnalysis();

	void setStaticAnalysis(StaticAnalysis staticAnalysis);

	StaticAnalysisPrinter getStaticAnalysisPrinter();

	void setStaticAnalysisPrinter(StaticAnalysisPrinter staticAnalysisPrinter);

	<D extends ProcessDefinition > boolean isCreateInstance(D def, InternalMessage<?> mess);
	
	
	
	
	

}
