package com.ebmwebsourcing.easyviper.core.api.tools;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;

public class PoolOfProcessForkers {

	/**
	 * Threads for pool of instances
	 */
	private  List<ProcessForker> processForkers = new CopyOnWriteArrayList<ProcessForker>();

	public  List<ProcessForker> getProcessForkers() {
		return processForkers;
	}

	public  void addProcessForkers(ProcessForker forker){
		processForkers.add(forker);
	}

	public  void removeFromKey(ProcessKey key) throws InterruptedException{
		Iterator<ProcessForker> itfork = processForkers.iterator();
		while(itfork.hasNext()){
			
			ProcessForker currentForker = itfork.next();
			
			Iterator<ProcessKey> itKeys = currentForker.getKeys().iterator();
			while(itKeys.hasNext()){
				
				ProcessKey currentKey = itKeys.next();				
				
				if(currentKey.equals(key)){

					currentForker.join(0, 1);
					processForkers.remove(currentForker);
					break;
				}

			}
			itfork = processForkers.iterator();
		}
	}

	public void removeAllForkers() throws InterruptedException{
		Iterator<ProcessForker> itfork = processForkers.iterator();

		while(itfork.hasNext()){

			ProcessForker currentForker = itfork.next();
			currentForker.join(0, 1);
			processForkers.remove(currentForker);

			itfork = processForkers.iterator();
		}
		
	}
}


