package com.ebmwebsourcing.easyviper.core.api.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.nonfunctionnal.NonFunctionnalBehaviour;


public class TransitionLinker {

	
	/*
	 * <NodeSource2NodeDestination> => List of transitions
	 */
	private Map<String, List<NonFunctionnalBehaviour>> links;
	
	public TransitionLinker(){
		
		links = new  ConcurrentHashMap<String, List<NonFunctionnalBehaviour>>();
	}
	
	public void addLink(String sourceNode, String destinationNode, List<NonFunctionnalBehaviour> behaviours){
		
		String pair = sourceNode+"2"+destinationNode;
		
		this.links.put(pair, behaviours);
		
	}
	
	
	public List<NonFunctionnalBehaviour> getNonFunctionnalBehaviours(String source, String destination){
		List<NonFunctionnalBehaviour> res = null;
		
		String key = source+"2"+destination;
		
		res = this.links.get(key);
		
		return res;
	}
	
	
}
