/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.factory;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import java.util.HashMap;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFactoryImpl {
    public static final String DEFAULT_FACTORY_NAME = "core";
    private static Logger log = Logger.getLogger(AbstractFactoryImpl.class.getName());
    private static Core core = null;

    protected Core createCore(String string, ConfigurationEngine configurationEngine, Class<? extends Core> clazz) throws CoreException {
        boolean bl = false;
        if (configurationEngine != null && configurationEngine.getExplorer() != null) {
            bl = configurationEngine.getExplorer();
        }
        Component component = this.createCoreComposite(bl, clazz);
        try {
            FractalHelper.getFractalHelper().startComponent(component);
            AbstractFactoryImpl.setCore(component);
            if (string != null) {
                FractalHelper.getFractalHelper().changeName(component, string);
            }
            AbstractFactoryImpl.setCore(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        log.finest("core created and started");
        return core;
    }

    private static void setCore(Component component) throws CoreException, NoSuchInterfaceException {
        core = (Core)component.getFcInterface("/content");
        core.init(component);
    }

    private Component createCoreComposite(boolean bl, Class<? extends Core> clazz) throws CoreException {
        Component component = null;
        if (!bl) {
            component = FractalHelper.getFractalHelper().createNewComponent(clazz.getName(), null);
        } else {
            Component component2 = FractalHelper.getFractalHelper().createNewComponent("CoreExplorer", new HashMap<Object, Object>());
            FractalHelper.getFractalHelper().startComponent(component2);
            Component component3 = FractalHelper.getFractalHelper().getComponents(component2).get(0);
            Component component4 = FractalHelper.getFractalHelper().getComponents(component3).get(1);
            component = FractalHelper.getFractalHelper().getComponents(component4).get(1);
        }
        FractalHelper.getFractalHelper().changeName(component, DEFAULT_FACTORY_NAME);
        return component;
    }

    public static Core getCore() {
        return core;
    }
}

