/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={Behaviour.class}, names={"abstract_service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public abstract class AbstractBehaviourImpl
extends SCAComponentImpl
implements Behaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(AbstractBehaviourImpl.class.getName());
    protected Behaviour.State state = Behaviour.State.ACTIVITY_INACTIVE;
    @Reference(name="node", required=false)
    protected Node node;

    @Override
    public QName getQName() throws CoreException {
        QName qName = QName.valueOf(this.getName());
        return qName;
    }

    @Override
    public void setQName(QName qName) throws CoreException {
        this.setName(qName.toString());
    }

    protected abstract void executeOnInactive() throws CoreException;

    protected abstract void executeOnStarted() throws CoreException;

    protected abstract void executeOnEnded() throws CoreException;

    @Override
    public void execute() throws CoreException {
        if (this.state == Behaviour.State.ACTIVITY_ENDED) {
            this.log.finest("restart the " + this.getName() + " activity");
            this.state = Behaviour.State.ACTIVITY_INACTIVE;
        }
        this.log.finest("execute the " + this.getName() + " activity on node (" + this.getNode().getName() + ") by execution (" + this.getNode().getExecution().getName() + ")");
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE) {
            this.executeOnInactive();
        } else if (this.state == Behaviour.State.ACTIVITY_STARTED) {
            this.executeOnStarted();
        } else if (this.state == Behaviour.State.ACTIVITY_ENDED) {
            this.executeOnEnded();
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public String toString() {
        String string = "";
        string = "behaviour " + this.getName() + " on Node " + this.getNode().getName();
        return string;
    }

    @Override
    public Behaviour.State getState() {
        return this.state;
    }

    @Override
    public void setState(Behaviour.State state) {
        this.state = state;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }
}

