/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl;

import static org.objectweb.fractal.fraclet.types.Step.CREATE;
import static org.objectweb.fractal.fraclet.types.Step.DESTROY;
import static org.objectweb.fractal.fraclet.types.Step.START;
import static org.objectweb.fractal.fraclet.types.Step.STOP;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoFlushMessageService;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageFactory;
import com.ebmwebsourcing.easyviper.core.fractal.Binding;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.EngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoTrashProcessServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.ExternalEnvironmentImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component
@Membrane(controller = "composite")
public class CoreImpl implements Core {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String DEFAULT_ENGINE_NAME = "WorkflowEngine";

	private Logger log = Logger.getLogger(CoreImpl.class.getCanonicalName());

	private Component engineComponent;

	private Component modelComponent;

	private Component externalEnvironmentComponent;
	
	private MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory;

	/**
	 * The Fractal scope composite component-
	 */
	@Controller
	private Component component;

	/**
	 * Default Constructor
	 * 
	 * @throws ADLException
	 */
	public CoreImpl() throws CoreException {
		super();
	}

	/**
	 * Start the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = CREATE)
	public void create() throws CoreException {
		this.log.fine("Fractal scope created: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	public void init(final Component fractalNode) throws CoreException {
		this.component = fractalNode;
		this.log.fine("Fractal scope initiated: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = START)
	public void start() throws CoreException {
		this.log.fine("Fractal scope started: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Stop the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = STOP)
	public void stop() throws CoreException {
		this.log.fine("Fractal scope stopped: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = DESTROY)
	public void destroy() throws CoreException {
		this.log.fine("Fractal scope destroyed: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	@SuppressWarnings("unchecked")
	public Engine createEngine(final ConfigurationEngine conf, final Class internalMessageType)
			throws CoreException {

		if (this.engineComponent != null) {
			throw new CoreException(
					"Error: Workflow engine already exist!!!");
		}

		Engine engine = null;
		this.engineComponent = FractalHelper.getFractalHelper()
				.createNewComponent(EngineImpl.class.getName(), null);
		FractalHelper.getFractalHelper().addComponent(this.engineComponent,
				this.component, null);

		try {
			engine = (Engine) this.engineComponent.getFcInterface("/content");
			engine.init(this.engineComponent);
			engine.setInternalMessageType(internalMessageType);
			
			if (!this.log.getName().equals(CoreImpl.class.getName())) {
				engine.setLog(this.log);
			}

			FractalHelper.getFractalHelper().startComponent(
					this.engineComponent);
			FractalHelper.getFractalHelper().changeName(this.engineComponent,
					CoreImpl.DEFAULT_ENGINE_NAME);

			engine = (Engine) this.engineComponent.getFcInterface("service");
			if(conf.getAutoFlushMessageFrequency() != null && conf.getAutoFlushMessageFrequency() > 0) {
				AutoFlushMessageService autoFlush = engine.getServiceManager().getService(AutoFlushMessageServiceImpl.class);
				autoFlush.setRefreshFrequency(conf.getAutoFlushMessageFrequency());
				
				engine.getServiceManager().activateService(AutoFlushMessageServiceImpl.class);
			}
			if(conf.getAutoTrashProcessFrequency() != null && conf.getAutoTrashProcessFrequency() > 0) {
				AutoTrashProcessService autoTrash = engine.getServiceManager().getService(AutoTrashProcessServiceImpl.class);
				autoTrash.setRefreshFrequency(conf.getAutoTrashProcessFrequency());
				engine.getServiceManager().activateService(AutoTrashProcessServiceImpl.class);
			}
			if(conf.getAdditionnalServices() != null) {
				for(Class<? extends Service> s: conf.getAdditionnalServices()) {
					engine.getServiceManager().addService(s);
				}
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("workflow engine created and started");
		return engine;
	}

	public Component getComponent() {
		return this.component;
	}

	public String getName() throws CoreException {
		return FractalHelper.getFractalHelper().getName(this.component);
	}

	public void setName(final String name) throws CoreException {
		if (name != null) {
			FractalHelper.getFractalHelper().changeName(this.component, name);
		}
	}

	public Engine getEngine() throws CoreException {
		Engine res = null;
		try {
			if (this.engineComponent != null) {
				res = (Engine) this.engineComponent.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public Model createModel(final String name, final Class<? extends Model> modelClass)
			throws CoreException {

		if (this.modelComponent != null) {
			throw new CoreException("Error: Model already exist!!!");
		}

		Model model = null;
		this.modelComponent = FractalHelper.getFractalHelper()
				.createNewComponent(modelClass.getName(), null);
		FractalHelper.getFractalHelper().addComponent(this.modelComponent,
				this.component, null);

		try {
			model = (Model) this.modelComponent.getFcInterface("/content");
			(model).init(this.modelComponent);
			if (!this.log.getName().equals(CoreImpl.class.getName())) {
				model.setLog(this.log);
			}

			FractalHelper.getFractalHelper()
					.startComponent(this.modelComponent);
			FractalHelper.getFractalHelper().changeName(this.modelComponent,
					name);

			model = (Model) this.modelComponent.getFcInterface("service");

			// link model to engine
			if (model != null) {
				final List<Binding> listOfBindings = new ArrayList<Binding>();
				listOfBindings.add(new Binding("model",
						(org.objectweb.fractal.api.Interface) model));
				FractalHelper.getFractalHelper().addBindings(
						this.engineComponent, listOfBindings);

			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("model created and started");

		return model;
	}

	public Model getModel() throws CoreException {
		Model res = null;
		try {
			if (this.modelComponent != null) {
				final Object obj = this.modelComponent.getFcInterface("service");
				res = (Model) this.modelComponent.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public ExternalEnvironment createExternalEnvironment(final String name)
			throws CoreException {
		ExternalEnvironment externalEnvironment = null;

		if (this.getEngine() == null) {
			throw new CoreException(
					"You must create the engine before create an external environment!!!");
		}

		final Component fractalExternalEnvironment = FractalHelper.getFractalHelper()
				.createNewComponent(ExternalEnvironmentImpl.class.getName(),
						null);
		FractalHelper.getFractalHelper().addComponent(
				fractalExternalEnvironment, this.component, null);
		this.externalEnvironmentComponent = fractalExternalEnvironment;

		try {
			// link externalEnvironment to engine
			if (this.getEngine() != null) {
				final List<Binding> listOfBindings = new ArrayList<Binding>();
				listOfBindings
						.add(new Binding("engine",
								(org.objectweb.fractal.api.Interface) this
										.getEngine()));
				FractalHelper.getFractalHelper().addBindings(
						this.externalEnvironmentComponent, listOfBindings);

			}

			externalEnvironment = (ExternalEnvironment) fractalExternalEnvironment
					.getFcInterface("/content");
			externalEnvironment.init(fractalExternalEnvironment);
			if (!this.log.getName().equals(CoreImpl.class.getName())) {
				externalEnvironment.setLog(this.log);
			}

			FractalHelper.getFractalHelper().startComponent(
					fractalExternalEnvironment);
			FractalHelper.getFractalHelper().changeName(
					fractalExternalEnvironment, name);

			externalEnvironment = (ExternalEnvironment) fractalExternalEnvironment
					.getFcInterface("service");

			// link engine to externalEnvironment
			final List<Binding> listOfBindings = new ArrayList<Binding>();
			listOfBindings.add(new Binding("externalEnv",
					(org.objectweb.fractal.api.Interface) externalEnvironment));
			FractalHelper.getFractalHelper().addBindings(this.engineComponent,
					listOfBindings);

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("external Environment created and started");

		return externalEnvironment;
	}

	public ExternalEnvironment getExternalEnvironment() throws CoreException {
		ExternalEnvironment res = null;
		try {
			if (this.externalEnvironmentComponent != null) {
				final Object obj = this.externalEnvironmentComponent
						.getFcInterface("service");
				res = (ExternalEnvironment) this.externalEnvironmentComponent
						.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}



	public MessageFactory<ExternalMessage<?>, InternalMessage<?>> getMessageFactory() {
		return this.messageFactory;
	}

	public void setMessageFactory(
			MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory)
			throws CoreException {
		this.messageFactory = messageFactory;
	}

}
