/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.SequenceBehaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = SequenceBehaviour.class))
public class SequenceBehaviourImpl extends AbstractBehaviourImpl implements
		SequenceBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger
			.getLogger(SequenceBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	public Map<String, Object> getInitializationContext()
			throws CoreException {
		return null;
	}

	public void setInitializationContext(final Map<String, Object> context)
			throws CoreException {
		// do nothing
	}

	@Override
	public void executeActivity() throws CoreException {
		if (this.state == State.ACTIVITY_INACTIVE) {
			this.log.finest("start sequence behaviour on node: "
					+ this.node.getName());
			this.state = State.ACTIVITY_STARTED;

			final List<Node> childs = this.node.getChildNodes();
			if ((childs != null) && (childs.size() > 0)) {

				// find first node
				Node firstNode = null;
				for (final Node node : childs) {

					// start the node component
					final Component nodeComp = FractalHelper.getFractalHelper()
							.getComponentByInterface(
									FractalHelper.getFractalHelper().getParent(
											this.getComponent()),
									(org.objectweb.fractal.api.Interface) node,
									"service");
					if ((nodeComp != null)
							&& (!FractalHelper.getFractalHelper().isStarted(
									nodeComp))) {
						FractalHelper.getFractalHelper().startComponent(
								nodeComp);
					}

					if ((node.getIncomingTransitions() == null)
							|| ((node.getIncomingTransitions() != null) && (node
									.getIncomingTransitions().size() == 0))) {
						firstNode = node;
						break;
					}
				}

				this.getNode().getNextSelectedExecutableElements().add(
						firstNode);
			}

		} else if (this.state == State.ACTIVITY_STARTED) {
			this.log
					.finest("end sequence behaviour on node: "
							+ this.node.getName());
			this.state = State.ACTIVITY_ENDED;
			this.getNode().getNextSelectedExecutableElements().clear();
		}
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public String toString() {
		return "Sequence";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}
}
