/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import java.util.Iterator;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.SequenceBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ReorganizationPatternFactory {

	private static ReorganizationPatternFactory instance;

	private ReorganizationPatternFactory() {

	}

	public static ReorganizationPatternFactory getInstance() {
		if (ReorganizationPatternFactory.instance == null) {
			ReorganizationPatternFactory.instance = new ReorganizationPatternFactory();
		}
		return ReorganizationPatternFactory.instance;
	}

	public Node convertFork2Sequence(Node forkNode, Scope parent) throws CoreException {
		try {
			if ((forkNode == null)||(parent == null)) {
				throw new CoreException("sequence node or scope cannot be null");
			}

			Component forkComp = FractalHelper.getFractalHelper().getComponentByInterface(parent.getComponent(), (Interface) forkNode, "service");  
			if(!FractalHelper.getFractalHelper().isStarted(forkComp)) {
				FractalHelper.getFractalHelper().startComponent(forkComp);
			}
			
			// unlink old behaviour
			Behaviour sequenceBehaviouur = forkNode.getBehaviour();
			parent.unlinkedNodeAndActivity(forkNode, sequenceBehaviouur);

			// delete old behaviour
			Component behaviourComp = FractalHelper.getFractalHelper().getComponentByInterface(parent.getComponent(), (Interface) sequenceBehaviouur, "service");
			FractalHelper.getFractalHelper().deleteComponent(behaviourComp);

			// change node name
			forkNode.setName(forkNode.getName().toLowerCase().replace("fork", "sequence"));
			
			// create new behaviour
			Behaviour sequenceBehaviour = new SequenceBehaviourImpl();
			final Component fractalActivity = FractalHelper.getFractalHelper()
			.createNewComponent(sequenceBehaviour.getClass().getName(),
					null);
			FractalHelper.getFractalHelper().changeName(
					fractalActivity,
					sequenceBehaviour.getClass().getSimpleName()
					+ "4"
					+ FractalHelper.getFractalHelper().getName(
							forkComp));
			FractalHelper.getFractalHelper().addComponent(fractalActivity,
					parent.getComponent(), null);
			sequenceBehaviour = (Behaviour) fractalActivity
			.getFcInterface("/content");

			((Behaviour) sequenceBehaviour).init(fractalActivity);
			((Behaviour) sequenceBehaviour).setInitializationContext(sequenceBehaviour
					.getInitializationContext());
			if (!parent.getLogger().getName().equals(ScopeImpl.class.getName())) {
				sequenceBehaviour.setLog(parent.getLogger());
			}
			sequenceBehaviour = (Behaviour) fractalActivity.getFcInterface("service");

			// link new behaviour
			parent.linkedNodeAndActivity(forkNode, sequenceBehaviour);
			
			// add transitions between all child node
			Iterator<Node> it = forkNode.getChildNodes().iterator();
			Node node1 = null;
			Component node1Comp = null;
			Node node2 = null;
			Component node2Comp = null;
			Transition transition = null;
			int i = 1;
			while(it.hasNext()) {
				node1 = it.next();
				node1Comp = FractalHelper.getFractalHelper().getComponentByInterface(parent.getComponent(), (Interface) node1, "service");
					
				if(it.hasNext()) {
					node2 = it.next();
					node2Comp = FractalHelper.getFractalHelper().getComponentByInterface(parent.getComponent(), (Interface) node2, "service");
				}
				
				if((node1 != null)&&(node2 != null)) {
					String transitionName = FractalHelper.getFractalHelper()
					.getName(node1Comp)
					+ "2"
					+ FractalHelper.getFractalHelper().getName(
							node2Comp);
					transition = parent.createTransition(transitionName, null);
					parent.linked(node1, transition, node2);
					i++;
				}
				
				node1 = null;
				node2 = null;
			}
			

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		}

		return forkNode;
	}


}
