/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.thread;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ThreadSignal extends Thread {

	Execution childExecution;
	Thread childThread;

	Execution parentExecution;

	Exception exception = null;

	private final Logger log = Logger.getLogger(ThreadSignal.class.getName());

	public ThreadSignal(final Execution parentExecution, final Execution childExecution,
			final Thread childThread) throws CoreException {
		this.childExecution = childExecution;
		this.parentExecution = parentExecution;
		this.childThread = childThread;
	}

	@Override
	public void run() {
		try {
			this.log.finest("wait the imminent end of execution of child : "
					+ this.childExecution.getName());
			this.childThread.join();
			this.log.finest("signal the parent execution : "
					+ this.parentExecution.getName());
			this.parentExecution.signal(this.childExecution);
		} catch (final Exception e) {
			e.printStackTrace();
			this.exception = e;
		}
	}

	public Exception getException() {
		return this.exception;
	}

	public Execution getChildExecution() {
		return this.childExecution;
	}

}
