/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.env;

import static org.objectweb.fractal.fraclet.types.Step.CREATE;
import static org.objectweb.fractal.fraclet.types.Step.DESTROY;
import static org.objectweb.fractal.fraclet.types.Step.START;
import static org.objectweb.fractal.fraclet.types.Step.STOP;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component
@Membrane(controller = "composite")
public class ExternalEnvironmentImpl implements ExternalEnvironment {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String DEFAULT_EXTERNAL_ENVIRONMENT_NAME = "ExternalEnvironment";

	private Logger log = Logger.getLogger(ExternalEnvironmentImpl.class
			.getName());

	private final List<Component> receivers = new ArrayList<Component>();

	private final List<Component> senders = new ArrayList<Component>();

	@Requires(name = "engine")
	private Engine engine;

	/**
	 * The Fractal scope composite component-
	 */
	@Controller
	private Component component;

	/**
	 * Default Constructor
	 * 
	 * @throws ADLException
	 */
	public ExternalEnvironmentImpl() throws CoreException {
		super();
	}

	/**
	 * Start the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = CREATE)
	public void create() throws CoreException {
		this.log.fine("Fractal environment created: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	public void init(final Component fractalNode) throws CoreException {
		this.component = fractalNode;
		this.log.fine("Fractal environment initiated: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = START)
	public void start() throws CoreException {
		this.log.fine("Fractal environment started: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Stop the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = STOP)
	public void stop() throws CoreException {
		this.log.fine("Fractal environment stopped: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = DESTROY)
	public void destroy() throws CoreException {
		this.log.fine("Fractal environment destroyed: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	public Receiver addReceiver(final Class<? extends Receiver> receiverClass,
			final MessageConverter messageConverter) throws CoreException {
		Receiver receiver = null;

		this.checkEngine();
		if (this.engine == null) {
			throw new CoreException(
					"You must create the engine before create an receiver!!!");
		}

		final Component fractalReceiver = FractalHelper.getFractalHelper()
				.createNewComponent(receiverClass.getName(), null);
		FractalHelper.getFractalHelper().addComponent(fractalReceiver,
				this.component, null);
		this.receivers.add(fractalReceiver);

		try {
			receiver = (Receiver) fractalReceiver.getFcInterface("/content");
			receiver.init(fractalReceiver);
			receiver.setMessageConverter(messageConverter);
			if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
				receiver.setLog(this.log);
			}

			FractalHelper.getFractalHelper().startComponent(fractalReceiver);
			FractalHelper.getFractalHelper()
					.changeName(
							fractalReceiver,
							receiverClass.getSimpleName() + "_"
									+ this.receivers.size());

			receiver = (Receiver) fractalReceiver.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("receiver created and started");

		return receiver;
	}

	public Component getComponent() {
		return this.component;
	}

	public String getName() throws CoreException {
		return FractalHelper.getFractalHelper().getName(this.component);
	}

	public void setName(final String name) throws CoreException {
		if (name != null) {
			FractalHelper.getFractalHelper().changeName(this.component, name);
		}
	}

	public List<Receiver> getReceivers() throws CoreException {
		final List<Receiver> res = new ArrayList<Receiver>();
		for (final Component comp : this.receivers) {
			try {
				res.add((Receiver) comp.getFcInterface("service"));
			} catch (final NoSuchInterfaceException e) {
				throw new CoreException(e);
			}
		}
		return res;
	}

	public Sender addSender(final Class<? extends Sender> senderClass,
			final MessageConverter messageConverter) throws CoreException {
		Sender sender = null;

		this.checkEngine();
		if (this.engine == null) {
			throw new CoreException(
					"You must create the engine before create an sender!!!");
		}

		final Component fractalSender = FractalHelper.getFractalHelper()
				.createNewComponent(senderClass.getName(), null);
		FractalHelper.getFractalHelper().addComponent(fractalSender,
				this.component, null);
		this.senders.add(fractalSender);

		try {
			sender = (Sender) fractalSender.getFcInterface("/content");
			sender.init(fractalSender);
			sender.setMessageConverter(messageConverter);
			if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
				sender.setLog(this.log);
			}

			FractalHelper.getFractalHelper().startComponent(fractalSender);
			FractalHelper.getFractalHelper().changeName(fractalSender,
					senderClass.getSimpleName() + "_" + this.senders.size());

			sender = (Sender) fractalSender.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("sender created and started");

		return sender;
	}

	public List<Sender> getSenders() throws CoreException {
		final List<Sender> res = new ArrayList<Sender>();
		for (final Component comp : this.senders) {
			try {
				res.add((Sender) comp.getFcInterface("service"));
			} catch (final NoSuchInterfaceException e) {
				throw new CoreException(e);
			}
		}
		return res;
	}

	// TODO: Fix bug: unnessary methods
	private void checkEngine() throws CoreException {
		try {
			if (this.engine == null) {
				final Component coreComp = FractalHelper.getFractalHelper()
						.getParent(this.getComponent());
				final Core core = (Core) coreComp
						.getFcInterface("service");
				this.engine = core.getEngine();
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
	}

	public Engine getEngine() {
		return this.engine;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}
}
