/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer;

import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class EndProcessItfAction implements MenuItem {

	// ==================================================================
	//
	// No internal state.
	//
	// ==================================================================

	// ==================================================================
	//
	// No constructor.
	//
	// ==================================================================

	// ==================================================================
	//
	// No internal method.
	//
	// ==================================================================

	// ==================================================================
	//
	// Public methods for ExtendedActionListener interface.
	//
	// ==================================================================

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.objectweb.util.explorer.api.MenuItem#actionPerformed(org.objectweb.util.explorer.api.MenuItemTreeView)
	 */
	public void actionPerformed(final MenuItemTreeView e) {
		final Process process = (Process) e.getSelectedObject();
		try {
			process.end(true);
		} catch (final CoreException e1) {
			e1.printStackTrace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.objectweb.util.explorer.api.MenuItem#getStatus(org.objectweb.util.explorer.api.TreeView)
	 */
	public int getStatus(final TreeView treeView) {
		final Process process = (Process) treeView.getSelectedObject();

		try {
			if (FractalHelper.getFractalHelper().isStarted(
					process.getComponent())) {
				return MenuItem.ENABLED_STATUS;
			}
		} catch (final CoreException e) {
			return MenuItem.NOT_VISIBLE_STATUS;
		}
		return MenuItem.NOT_VISIBLE_STATUS;
	}
}