/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer.panel;

import javax.swing.JButton;
import javax.swing.table.TableColumn;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.MenuItemTreeView;

import com.ebmwebsourcing.easyviper.explorer.model.TableMessagesButtonEditor;
import com.ebmwebsourcing.easyviper.explorer.model.TableMessagesButtonRenderer;
import com.ebmwebsourcing.easyviper.explorer.model.TableMessagesModel;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiver;

/**
 * 
 * @author Nico
 */
public class EditMessagesRegistry extends javax.swing.JFrame {

	private MemoryReceiver receiver;

	/** Creates new form EditMessagesRegistry */
	public EditMessagesRegistry(final MenuItemTreeView e, final Component component) {
		this.initComponents();

		try {
			if (component != null) {
				this.receiver = (MemoryReceiver) component.getFcInterface("service");
			}

		} catch (final NoSuchInterfaceException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		this.jTableMessages.setModel(new TableMessagesModel(this.receiver
				.getMessages()));

		final TableMessagesButtonRenderer tmbr = new TableMessagesButtonRenderer();
		this.jTableMessages.setDefaultRenderer(JButton.class, tmbr);

		final TableMessagesButtonEditor tmbe = new TableMessagesButtonEditor(
				this.jTableMessages, this.receiver);

		final TableColumn openButton = this.jTableMessages.getColumnModel()
				.getColumn(1);
		openButton.setCellRenderer(tmbr);
		openButton.setCellEditor(tmbe);

		final TableColumn replayButton = this.jTableMessages.getColumnModel()
				.getColumn(2);
		replayButton.setCellRenderer(tmbr);
		replayButton.setCellEditor(tmbe);

	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated
	// Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		this.jScrollPane1 = new javax.swing.JScrollPane();
		this.jTableMessages = new javax.swing.JTable();

		this.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		this.setTitle("Edit Messages Registry");

		this.jTableMessages.setModel(new javax.swing.table.DefaultTableModel(
				new Object[][] { { null, null, null, null },
						{ null, null, null, null }, { null, null, null, null },
						{ null, null, null, null } }, new String[] { "Title 1",
						"Title 2", "Title 3", "Title 4" }));
		this.jScrollPane1.setViewportView(this.jTableMessages);

		final org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
				this.getContentPane());
		this.getContentPane().setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup(
				org.jdesktop.layout.GroupLayout.LEADING).add(
				layout.createSequentialGroup().addContainerGap().add(
						this.jScrollPane1,
						org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 679,
						Short.MAX_VALUE).addContainerGap()));
		layout.setVerticalGroup(layout.createParallelGroup(
				org.jdesktop.layout.GroupLayout.LEADING).add(
				org.jdesktop.layout.GroupLayout.TRAILING,
				layout.createSequentialGroup().addContainerGap().add(
						this.jScrollPane1,
						org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407,
						Short.MAX_VALUE).addContainerGap()));

		this.pack();
	}// </editor-fold>//GEN-END:initComponents

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(final String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new EditMessagesRegistry(null, null).setVisible(true);
			}
		});
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JTable jTableMessages;
	// End of variables declaration//GEN-END:variables

}
