/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.fractal.Binding;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.ThreadExecution;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.ThreadSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Cardinality;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="service", signature=Execution.class)})
@Membrane(controller="primitive")
public class ExecutionImpl
implements Execution,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ExecutionImpl.class.getName());
    private boolean stepByStep = false;
    private Execution.State currentState;
    @Requires(contingency=Contingency.OPTIONAL, name="currentTarget")
    private ExecutableElement currentTarget;
    private ThreadGroup group = null;
    @Requires(contingency=Contingency.OPTIONAL, name="parentExec")
    private Execution parent = null;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="childs")
    private final Map<String, Execution> childExecutions = new TreeMap<String, Execution>();
    private long speedTime;
    private ThreadSignal threadSignal;
    @Controller
    private org.objectweb.fractal.api.Component component;

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ExecutionImpl() {
        try {
            this.createFc();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void listFc(List<String> list) {
        list.addAll((Collection<String>)this.childExecutions.keySet());
        if (this.parent != null) {
            list.add("parentExec");
        }
        if (this.currentTarget != null) {
            list.add("currentTarget");
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith("childs")) {
            return this.childExecutions.get(string);
        }
        if (string.equals("parentExec")) {
            return this.parent;
        }
        if (string.equals("currentTarget")) {
            return this.currentTarget;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    public String getFcState() {
        return null;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.startsWith("childs")) {
            this.childExecutions.put(string, (Execution)object);
            return;
        }
        if (string.equals("parentExec")) {
            this.parent = (Execution)object;
            return;
        }
        if (string.equals("currentTarget")) {
            this.currentTarget = (ExecutableElement)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith("childs")) {
            this.childExecutions.remove(string);
            return;
        }
        if (string.equals("parentExec")) {
            this.parent = null;
            return;
        }
        if (string.equals("currentTarget")) {
            this.currentTarget = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    public ExecutableElement getCurrentTarget() {
        return this.currentTarget;
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal execution created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal execution initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("start execution: " + this.getName());
        this.setState(Execution.State.ACTIVE);
        this.group = new ThreadGroup(this.getName());
    }

    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("stop execution: " + this.getName());
        this.setState(Execution.State.SUSPENDED);
    }

    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal execution destroyed: " + this.getName());
        this.setState(Execution.State.CANCELLED);
    }

    public Scope getParentScope() throws CoreException {
        Scope scope = null;
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.component);
        try {
            scope = (Scope)component.getFcInterface("scope");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return scope;
    }

    public synchronized void run() throws CoreException {
        ExecutableElement executableElement = this.currentTarget;
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)executableElement, "service");
        if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
            FractalHelper.getFractalHelper().startComponent(component);
        }
        if (this.currentTarget != null && this.currentTarget.getNextSelectedExecutableElements() != null) {
            this.currentTarget.getNextSelectedExecutableElements().clear();
            this.currentTarget.getNextSelectedExecutableElements().add(this.currentTarget);
            if (!this.stepByStep) {
                this.next();
            }
        } else {
            throw new CoreException("Error initialization exception");
        }
    }

    public void removeChildExecution(Execution execution) throws CoreException {
        org.objectweb.fractal.api.Component component;
        if (execution != null && (component = FractalHelper.getFractalHelper().getComponentByInterface(this.getParentScope().getComponent(), (Interface)execution, "service")) != null) {
            FractalHelper.getFractalHelper().deleteComponent(component);
        }
    }

    public void end() throws CoreException {
        try {
            if (FractalHelper.getFractalHelper().isBinded(this.component, "currentTarget")) {
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("currentTarget", (Interface)((Node)this.currentTarget).getComponent().getFcInterface("service")));
                FractalHelper.getFractalHelper().deleteBindings(this.component, arrayList);
            }
            this.group = new ThreadGroup(this.getName());
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public Execution getChildExecution(String string) {
        return this.childExecutions.get(string);
    }

    public List<Execution> getChildExecutions() {
        ArrayList<Execution> arrayList = new ArrayList<Execution>();
        arrayList.addAll(this.childExecutions.values());
        return arrayList;
    }

    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    public Execution getParentExecution() {
        return this.parent;
    }

    public Execution.State getState() {
        return this.currentState;
    }

    public void setState(Execution.State state) {
        this.currentState = state;
    }

    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    public Execution createChildExecution(String string) throws CoreException {
        Execution execution = this.getParentScope().createExecution(String.valueOf(this.getName()) + "_child_" + this.childExecutions.size());
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getParentScope().getComponent(), (Interface)execution, "service");
        FractalHelper.getFractalHelper().startComponent(component);
        execution.setStepByStep(this.stepByStep);
        execution.setSpeedTime(this.speedTime);
        this.log.finest("creating " + execution.getName());
        this.addExecution(execution);
        return execution;
    }

    public void addExecution(Execution execution) throws CoreException {
        try {
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            arrayList.add(new Binding("childs_" + String.valueOf(this.childExecutions.size()), (Interface)execution.getComponent().getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(this.getComponent(), arrayList);
            arrayList = new ArrayList();
            arrayList.add(new Binding("parentExec", (Interface)this.getComponent().getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(execution.getComponent(), arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void removeChildExecutions() throws CoreException {
        Execution execution = null;
        while (this.childExecutions.values() != null && this.childExecutions.values().size() > 0) {
            execution = this.childExecutions.values().iterator().next();
            this.log.finest("remove execution: " + execution.getName());
            this.removeChildExecution(execution);
        }
    }

    public void setParent(Execution execution) {
        this.parent = execution;
    }

    public synchronized void next() throws CoreException {
        block30: {
            try {
                Execution execution;
                Process process;
                Execution.State state = this.currentState;
                ExecutableElement executableElement = this.currentTarget;
                if (this.speedTime > 0L) {
                    try {
                        Thread.sleep(this.speedTime);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CoreException((Throwable)interruptedException);
                    }
                }
                if (state == Execution.State.ACTIVE && this.stepByStep) {
                    this.currentState = Execution.State.SUSPENDED;
                }
                if (state != Execution.State.ACTIVE) break block30;
                if (executableElement != null && executableElement.getNextSelectedExecutableElements().size() == 1) {
                    this.execute((ExecutableElement)executableElement.getNextSelectedExecutableElements().get(0));
                } else if (executableElement != null && executableElement.getNextSelectedExecutableElements().size() > 1) {
                    this.log.finest("start multithread executions for execution: " + this.getName());
                    process = new ArrayList();
                    process.addAll(executableElement.getNextSelectedExecutableElements());
                    executableElement.getNextSelectedExecutableElements().clear();
                    execution = new ArrayList();
                    Iterator iterator = process.iterator();
                    ExecutableElement executableElement2 = null;
                    while (iterator.hasNext()) {
                        executableElement2 = (ExecutableElement)iterator.next();
                        ThreadExecution threadExecution = this.createChildExecution(String.valueOf(this.getName()) + "_child_" + this.childExecutions.size());
                        ExecutableElement executableElement3 = executableElement2;
                        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)executableElement3, "service");
                        if (!FractalHelper.getFractalHelper().isAlreadyBind(threadExecution.getComponent(), "currentTarget", (Interface)executableElement3)) {
                            this.getParentScope().linkedExecution2ExecutableElement((Execution)threadExecution.getComponent().getFcInterface("service"), executableElement3);
                        }
                        if (!FractalHelper.getFractalHelper().isAlreadyBind(component, "execution", (Interface)((Execution)threadExecution.getComponent().getFcInterface("service")))) {
                            this.getParentScope().linkedExecutableElement2Execution((ExecutableElement)component.getFcInterface("service"), (Execution)threadExecution.getComponent().getFcInterface("service"));
                        }
                        if (!this.isStepByStep()) {
                            ThreadExecution threadExecution2 = new ThreadExecution(this.group, (Execution)threadExecution);
                            threadExecution2.start();
                            execution.add(threadExecution2);
                            continue;
                        }
                        threadExecution.setStepByStep(true);
                        threadExecution.run();
                    }
                    if (!this.isStepByStep()) {
                        try {
                            for (ThreadExecution threadExecution : execution) {
                                threadExecution.join();
                                if (threadExecution.getException() != null) {
                                    this.log.finest("error in child execution: " + threadExecution.getChildExecution().getName());
                                    throw new CoreException((Throwable)threadExecution.getException());
                                }
                                this.log.finest("child execution " + threadExecution.getChildExecution().getName() + " is " + threadExecution.getChildExecution().getState());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            throw new CoreException((Throwable)interruptedException);
                        }
                        this.deleteEndedChildExecution();
                        if (this.childExecutions.values().size() == 0) {
                            this.log.finest("All childs have finished => restart the parent execution");
                            if (executableElement != null) {
                                this.currentState = Execution.State.ACTIVE;
                                state = Execution.State.ACTIVE;
                                this.execute(executableElement);
                            }
                        } else {
                            this.log.finest("Some executions must be suspended");
                            this.log.finest("So, execution suspended");
                            this.currentState = Execution.State.SUSPENDED;
                            state = Execution.State.SUSPENDED;
                        }
                    }
                }
                if (state != Execution.State.ACTIVE || this.currentTarget == null || this.currentTarget.getNextSelectedExecutableElements().size() != 0) break block30;
                if (this.childExecutions.size() > 0) {
                    this.log.finest("wait the end of child node");
                    process = this.childExecutions.values().iterator();
                    while (process.hasNext()) {
                        execution = (Execution)process.next();
                        if (execution.getState() != Execution.State.ENDED) continue;
                        this.signal(execution);
                        process = this.childExecutions.values().iterator();
                    }
                    break block30;
                }
                if (this.currentTarget.selectDefaultNextTarget().size() != 0) break block30;
                if (this.currentState != Execution.State.ENDED) {
                    this.log.finest("Execution ended: " + this.getName());
                }
                this.currentState = Execution.State.ENDED;
                state = Execution.State.ENDED;
                if (this.getParentExecution() == null) {
                    if (!FractalHelper.getFractalHelper().isAlreadyBind(executableElement.getComponent(), "execution", (Interface)((Execution)this.getComponent().getFcInterface("service")))) {
                        this.getParentScope().linkedExecutableElement2Execution((ExecutableElement)executableElement.getComponent().getFcInterface("service"), (Execution)this.getComponent().getFcInterface("service"));
                    }
                    process = null;
                    try {
                        process = (Process)this.getParentScope().getComponent().getFcInterface("process");
                    }
                    catch (Exception exception) {}
                    if (process != null && process.getState() == Process.State.PROCESS_ACTIVE) {
                        process.end(false);
                    }
                    break block30;
                }
                if (this.threadSignal == null) {
                    this.threadSignal = new ThreadSignal(this.getParentExecution(), this, Thread.currentThread());
                    this.threadSignal.start();
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException((Throwable)noSuchInterfaceException);
            }
        }
    }

    public synchronized void execute(ExecutableElement executableElement) throws CoreException {
        block8: {
            this.log.finest("Entering in execute method");
            try {
                if (executableElement == null) break block8;
                ExecutableElement executableElement2 = executableElement;
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)executableElement2, "service");
                FractalHelper.getFractalHelper().deleteLinkWithAnItfClientOfComponent(this.getComponent(), "currentTarget");
                if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
                    FractalHelper.getFractalHelper().startComponent(component);
                }
                this.log.finest("run the next elmt for execution: " + this.getName() + " => " + executableElement2.getName());
                if (!FractalHelper.getFractalHelper().isAlreadyBind(this.getComponent(), "currentTarget", (Interface)executableElement2)) {
                    this.getParentScope().linkedExecution2ExecutableElement((Execution)this.getComponent().getFcInterface("service"), executableElement2);
                }
                if (!FractalHelper.getFractalHelper().isAlreadyBind(component, "execution", (Interface)((Execution)this.getComponent().getFcInterface("service")))) {
                    this.getParentScope().linkedExecutableElement2Execution((ExecutableElement)component.getFcInterface("service"), (Execution)this.getComponent().getFcInterface("service"));
                }
                try {
                    if (component.getFcInterface("scope") != null) {
                        Node node = (Node)component.getFcInterface("service");
                        node.setExecution((Execution)this);
                    }
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {}
                executableElement.getNextSelectedExecutableElements().clear();
                executableElement.execute();
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException((Throwable)noSuchInterfaceException);
            }
        }
        this.log.finest("Exit of execute method");
    }

    public long getSpeedTime() {
        return this.speedTime;
    }

    public void setSpeedTime(long l) {
        this.speedTime = l;
    }

    public void runSlowly(long l) throws CoreException {
        this.setSpeedTime(l);
        this.run();
    }

    public void runStepByStep() throws CoreException {
        this.stepByStep = true;
        this.run();
    }

    public synchronized void signal() throws CoreException {
        this.signal(null);
    }

    public synchronized void signal(Execution execution) throws CoreException {
        if (execution != null) {
            this.log.finest("wake up of execution: " + this.getName() + " by " + execution.getName());
        } else {
            this.log.finest("wake up of execution: " + this.getName() + " by external user");
        }
        this.deleteEndedChildExecution();
        if (execution != null && this.currentTarget != null) {
            this.currentTarget.getNextSelectedExecutableElements().clear();
            this.currentTarget.getNextSelectedExecutableElements().add(this.currentTarget);
        }
        if (this.currentState != Execution.State.ENDED) {
            if (execution != null) {
                this.currentState = Execution.State.SUSPENDED;
            } else {
                this.currentState = Execution.State.ACTIVE;
                if (this.getParentExecution() == null) {
                    this.log.finest("call next method for execution: " + this.getName());
                    this.next();
                } else if (!this.stepByStep) {
                    this.log.finest("Start child execution in thread");
                    ThreadExecution threadExecution = new ThreadExecution(this.group, this);
                    threadExecution.start();
                } else {
                    this.next();
                }
            }
        }
    }

    private void deleteEndedChildExecution() throws CoreException {
        Iterator<Execution> iterator = this.childExecutions.values().iterator();
        while (iterator.hasNext()) {
            Execution execution = iterator.next();
            if (execution.getState() != Execution.State.ENDED) continue;
            this.log.finest("remove the child execution : " + execution.getName());
            this.removeChildExecution(execution);
            iterator = this.childExecutions.values().iterator();
        }
    }

    public boolean isStepByStep() {
        return this.stepByStep;
    }

    public void setStepByStep(boolean bl) {
        this.stepByStep = bl;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public String toString() {
        String string = super.toString();
        try {
            if (this.getName() != null) {
                string = this.getName();
            }
        }
        catch (CoreException coreException) {}
        return string;
    }
}

