/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=ReceiverBehaviour.class)})
public class ReceiverBehaviourImpl
extends AbstractBehaviourImpl
implements ReceiverBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ReceiverBehaviourImpl.class.getName());
    private InternalMessage<?> message;
    private List<QName> variableNames = new ArrayList<QName>();
    private MessageMatcher messageMatcher = null;
    private List<CorrelationMatcher> correlationsMatcher = null;
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private Node childNodeSelected = null;
    private boolean isSuspended = false;

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message", this.message);
        hashMap.put("variableNames", this.variableNames);
        hashMap.put("correlationsMatcher", this.correlationsMatcher);
        hashMap.put("messageMatcher", this.messageMatcher);
        return hashMap;
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.message = (InternalMessage)map.get("message");
        this.variableNames = (List)map.get("variableNames");
        this.correlationsMatcher = (List)map.get("correlationsMatcher");
        this.messageMatcher = (MessageMatcher)map.get("messageMatcher");
    }

    public void executeActivity() throws CoreException {
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE || this.isSuspended) {
            this.isSuspended = false;
            this.log.finest("execute receive behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_STARTED;
            if (this.message != null) {
                boolean bl = this.accept(this.message, this.getNode().getExecution().getParentScope().getProcess().getExternalContext());
                if (bl) {
                    this.log.finest("Message accepted by the received activity: " + this.getName());
                    if (this.getChildNodeSelected() != null) {
                        this.getNode().getNextSelectedExecutableElements().add(this.getChildNodeSelected());
                    }
                } else {
                    this.getNode().getExecution().setState(Execution.State.SUSPENDED);
                    this.isSuspended = true;
                    this.log.finest("Message does not correspond - execution suspended: " + this.getNode().getExecution().getState());
                    this.getNode().getNextSelectedExecutableElements().add(this.getNode());
                }
                this.message = null;
            } else {
                this.getNode().getExecution().setState(Execution.State.SUSPENDED);
                this.isSuspended = true;
                this.log.finest("No Message - execution suspended: " + this.getNode().getExecution().getState());
                this.getNode().getNextSelectedExecutableElements().add(this.getNode());
            }
        } else if (this.state == Behaviour.State.ACTIVITY_STARTED) {
            this.log.finest("end receive behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.log.finest("received activity ended");
            this.setMessage(null);
            this.childNodeSelected = null;
            this.getNode().getNextSelectedExecutableElements().clear();
        }
    }

    public String toString() {
        return "Receive Behaviour";
    }

    public Node getNode() {
        return this.node;
    }

    public boolean accept(InternalMessage<?> internalMessage, ExternalContext externalContext) throws CoreException {
        boolean bl = false;
        this.log.finest("Message receive on node: " + this.node.getName());
        Scope scope = this.node.getExecution().getParentScope();
        int n = 0;
        for (QName qName : this.getVariableNames()) {
            Variable variable = scope.findVariable(qName);
            if (variable == null) {
                throw new CoreException("Impossible to find in process, the variable used in the received : " + this.getName());
            }
            boolean bl2 = false;
            if (this.getMessageMatcher() != null) {
                bl2 = this.getMessageMatcher().match(variable, internalMessage);
            } else {
                this.log.warning("no matcher found");
                bl2 = true;
            }
            if (!bl2) {
                this.log.finest("message not valid for variable: " + qName);
            } else {
                boolean bl3 = false;
                if (this.correlationsMatcher != null) {
                    this.log.finest("Correlation found: execute correlation for receiver: " + this.getName());
                    for (CorrelationMatcher correlationMatcher : this.correlationsMatcher) {
                        bl3 = correlationMatcher.match(scope, qName, internalMessage);
                        if (!bl3) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.log.finest("No correlation ");
                    bl3 = true;
                }
                if (bl2 && bl3) {
                    variable.setValue(internalMessage);
                    bl = true;
                    this.log.finest("Message accepted on receive by variable: " + qName);
                    if (this.node.getChildNodes().size() <= 0) break;
                    this.childNodeSelected = (Node)this.node.getChildNodes().get(n);
                    break;
                }
            }
            ++n;
        }
        return bl;
    }

    public List<QName> getVariableNames() {
        if (this.variableNames == null) {
            this.variableNames = new ArrayList<QName>();
        }
        return this.variableNames;
    }

    public void addVariableName(QName qName) {
        this.getVariableNames().add(qName);
    }

    public void setMessage(InternalMessage<?> internalMessage) {
        this.message = internalMessage;
    }

    public InternalMessage<?> getMessage() {
        return this.message;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public Node getChildNodeSelected() {
        return this.childNodeSelected;
    }

    public List<CorrelationMatcher> getCorrelationsMatchers() {
        return this.correlationsMatcher;
    }

    public void setCorrelationsMatchers(List<CorrelationMatcher> list) {
        this.correlationsMatcher = list;
    }

    public MessageMatcher getMessageMatcher() {
        return this.messageMatcher;
    }

    public void setMessageMatcher(MessageMatcher messageMatcher) {
        this.messageMatcher = messageMatcher;
    }
}

