/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.thread.service;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class AutoTrashProcessServiceImpl
extends AbstractServiceImpl
implements AutoTrashProcessService {
    private static final int NUMBER_OF_CLEAN_BEFORE_DELETING = 2;
    private Logger log = Logger.getLogger(AutoTrashProcessServiceImpl.class.getName());
    private final List<TrashProcessInstance> list = Collections.synchronizedList(new ArrayList());

    public AutoTrashProcessServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            this.tryToEndAllProcessIntances();
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.severe("Error in auto trash service: " + exception.getMessage());
        }
    }

    public void tryToEndAllProcessIntances() {
        ArrayList<TrashProcessInstance> arrayList = new ArrayList<TrashProcessInstance>();
        arrayList.addAll(this.list);
        this.list.clear();
        for (TrashProcessInstance trashProcessInstance : arrayList) {
            try {
                if (trashProcessInstance.getNumberOfClean() == 2) {
                    this.log.warning("try to delete instance: " + trashProcessInstance.getProcessInstance().getName());
                    FractalHelper.getFractalHelper().stopComponent(trashProcessInstance.getProcessInstance().getComponent());
                    FractalHelper.getFractalHelper().deleteComponent(trashProcessInstance.getProcessInstance().getComponent());
                    continue;
                }
                this.log.warning("try to clean instance: " + trashProcessInstance.getProcessInstance().getName());
                trashProcessInstance.getProcessInstance().end(true);
                List<Process> list = ((MemoryProcessInstanceRegistryImpl)this.getEngine().getProcessInstanceRegistry()).getMap().get(trashProcessInstance.getProcessInstance().getProcessKey());
                if (list == null) {
                    list = new ArrayList<Process>();
                }
                list.add(trashProcessInstance.getProcessInstance());
                ((MemoryProcessInstanceRegistryImpl)this.getEngine().getProcessInstanceRegistry()).getMap().put(trashProcessInstance.getProcessInstance().getProcessKey(), list);
            }
            catch (CoreException coreException) {
                trashProcessInstance.setNumberOfClean(trashProcessInstance.getNumberOfClean() + 1);
                try {
                    this.log.warning("impossible to ended this instance: " + trashProcessInstance.getProcessInstance().getName());
                }
                catch (CoreException coreException2) {}
                this.list.add(trashProcessInstance);
            }
        }
    }

    public void addUninstableProcessInstance(Process process) {
        if (process.getState().equals((Object)Process.State.PROCESS_UNSTABLE)) {
            this.list.add(new TrashProcessInstance(process));
        }
    }

    private class TrashProcessInstance {
        private int numberOfClean = 0;
        private Process processInstance = null;

        public TrashProcessInstance(Process process) {
            this.processInstance = process;
        }

        public int getNumberOfClean() {
            return this.numberOfClean;
        }

        public void setNumberOfClean(int n) {
            this.numberOfClean = n;
        }

        public Process getProcessInstance() {
            return this.processInstance;
        }
    }
}

