/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.ExtendedBehaviour;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.ExtendedBehaviourService;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.JarException;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.JarLoaderManager;

public class ExtendedBehaviourServiceImpl extends AbstractServiceImpl implements ExtendedBehaviourService {

	private Logger log = Logger.getLogger(ExtendedBehaviourServiceImpl.class.getName());

	private final List<ExtendedBehaviour> behaviours = Collections.synchronizedList(new ArrayList<ExtendedBehaviour>());

	public ExtendedBehaviourServiceImpl(Engine engine) {
		super(engine);
	}

	public void run() {
		try {

			Thread.sleep(this.getRefreshFrequency());

		} catch (Exception e) {
			e.printStackTrace();
			log.severe("Error in auto trash service: " + e.getMessage());
		} 	
	}

	public List<Class<? extends ExtendedBehaviour>> getExtendedBehaviourInJar(
			URL jarUrl) throws JarException {
		File f;
		try {
			f = new File(jarUrl.toURI());
		} catch(URISyntaxException e) {
			f = new File(jarUrl.getPath());
		}
		return JarLoaderManager.getInstance().getClassInJar(f, Thread.currentThread().getContextClassLoader(), ExtendedBehaviour.class);
	}

	public List<? extends ExtendedBehaviour> loadExtendedBehaviour()
	throws CoreException {

		return null;
	}



}
