/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.logging.Logger;

public class JarLoaderManager {

	private Logger log = Logger.getLogger(JarLoaderManager.class.getCanonicalName());


	private static JarLoaderManager instance = null;

	public static JarLoaderManager getInstance() {
		if(instance == null) {
			instance = new JarLoaderManager();
		}
		return instance;
	}

	private JarLoaderManager() {

	}



	public <C> List<Class<? extends C>> getClassInJar(File jarString, ClassLoader parent, Class<? extends C> class2found) throws JarException {
		List<Class<? extends C>> res = new ArrayList<Class<? extends C>>();
		if(!class2found.isInterface()) {
			throw new JarException("The class2found parameter must be an interface!!!");
		}
		List<File> orderedClasspath = extractJarFileFromManifest(jarString);
		List<File> jar2reload = jar2Reload(orderedClasspath, parent, class2found, res);
		while(jar2reload.size() > 0) {
			jar2reload = jar2Reload(jar2reload, parent, class2found, res);
		}

		return res;
	}

	private List<File> extractJarFileFromManifest(File jarFile) {
		List<File> orderedClasspath = new ArrayList<File>();
		JarLoader jar = new JarLoader(jarFile, null);
		if(jar.getManifest() != null) {
			Attributes attr =  jar.getManifest().getMainAttributes();
			if(attr != null && attr.getValue("Class-Path") != null) {
				StringTokenizer st = new StringTokenizer(attr.getValue("Class-Path"), " ");
				List<String> classpath = new ArrayList<String>();
				while(st.hasMoreElements()) {
					classpath.add(jarFile.getAbsolutePath().substring(0,jarFile.getAbsolutePath().lastIndexOf(File.separatorChar)+1) + st.nextToken());
				}
				classpath.add(0, jarFile.toString());

				// reverse order
				for(String file: classpath) {
					orderedClasspath.add(0, new File(file));
				}
				
			}
		}
		return orderedClasspath;
	}

	private <C> List<File> jar2Reload(List<File> jars, ClassLoader parent, Class<? extends C> class2found, List<Class<? extends C>> res) {
		List<File> jar2reload = new ArrayList<File>();
		Iterator<File> it = jars.iterator();
		while(it.hasNext()) {
			File jar = it.next();
			try {
				parent = new JarLoader(jar, parent);
				List<Class<?>> classes = ((JarLoader)parent).makeJarClassList();
				
				for(Class<?> c: classes) {
					if(!c.isInterface() && isClassExtendOfClass2found(c, class2found)) {
						res.add((Class<? extends C>)c);
					}
				}
			} catch(NoClassDefFoundError e) {
				log.warning("Impossible to load this jar for the moment: " + jar);
				jar2reload.add(jar);
			} 
		}
		return jar2reload;
	}

	private <C> boolean isClassExtendOfClass2found(Class<?> c, Class<? extends C> class2found) {
		boolean res = false;
		
		try {
			if(c != null) {
				if(c.getName().equals(class2found.getName())) {
					res = true;
					
				} else if(c.getInterfaces() != null) {
					for(Class<?> subc : c.getInterfaces()) {
						res = isClassExtendOfClass2found(subc, class2found);
						if(res == true) {
							break;
						}
					}
				}
			}
		} catch(ClassCastException e) {

		}
		return res;
	}

	//	/**
	//	 * methode permettant le parcours d'un repertoire a la recherche des jar
	//	 * 
	//	 * @param dir
	//	 *            le fichier initiale
	//	 * @param recur
	//	 *            si vrai on liste recursivement le repertoire
	//	 * @return Vector<JarLoader>
	//	 */
	//	public List<JarLoader> getJarList(String dir, boolean recur, ClassLoader parent) {
	//		List<File> files = this.getJarListInString(dir, recur);
	//		return this.getJarList(files, parent);
	//	}
	//
	//
	//	private List<File> getJarListInString(String dir, boolean recur) {
	//		List<File>	vjl	= new ArrayList<File>();
	//		File pgDir = new File(dir);
	//		File[] ls = pgDir.listFiles();
	//		if (ls == null || ls.length == 0)
	//			return null;
	//		for (File f : ls) {
	//			if (f.isFile() && f.getName().endsWith("jar")) {
	//				vjl.add(f);
	//			} else if (f.isDirectory() && recur) {
	//				vjl.addAll(getJarListInString(f.getAbsolutePath(), true));
	//			}
	//		}
	//		return vjl;
	//	}
	//
	//
	//	public List<JarLoader> getJarList(List<File> jars, ClassLoader parent) {
	//		List<JarLoader>	vjl	= new ArrayList<JarLoader>();
	//		if(jars != null) {
	//			for (File f : jars) {
	//				if (f.isFile() && f.getName().endsWith("jar")) {
	//					try {
	//						// test le si le fichier est un jar valide
	//						new JarFile(f);
	//						vjl.add(new JarLoader(f, parent));
	//					} catch (IOException e) {
	//						continue;
	//					}
	//				} 
	//			}
	//		}
	//		return vjl;
	//	}
}
