/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.copy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;



public class JarLoader extends ClassLoader {
	private static Runtime				r;
	private List<Class<?>>			classList		= new ArrayList<Class<?>>();
	private File						file			= null;
	private Hashtable<String, byte[]>	hs				= new Hashtable<String, byte[]>();
	private Manifest					manifest		= null;
	private Hashtable<String, Integer>	sizeOfClass		= new Hashtable<String, Integer>();
	private boolean						wereUnload		= false;
	private Hashtable<Class<?>, Object>	instanceTable	= new Hashtable<Class<?>, Object>();

	private Logger log = Logger.getLogger(JarLoader.class.getCanonicalName());


	public static String				TMPDIR;
	static {
		r = Runtime.getRuntime();
		TMPDIR = System.getProperty("java.io.tmpdir");
	}

	public JarLoader(File f, ClassLoader parent) {
		super(parent);
		this.file = f;
		load();
	}

	public JarLoader(String s, ClassLoader parent) {
		this(new File(s), parent);
	}



	/**
	 * recherche une classe dans un package par son nom
	 * 
	 * @param classe
	 *            la classe recherche
	 * @return on renvois un Object class
	 */

	public Class<?> findJarClass(String classe) {
		if (classe == null)
			throw new NullPointerException(
			"impossible de rechercher une classe nulle");
		Enumeration<String> en = hs.keys();
		Class<?> c = null;
		while (en.hasMoreElements()) {
			String s = en.nextElement();
			String ss = s.substring(0, s.indexOf('.'));
			String name = ss.replace("/", ".");
			// System.out.println(classe + "\n" + name);
			if (classe.compareTo(name) == 0) {
				try {
					byte[] b = hs.get(s);
					c = defineClass(name, b, 0, b.length);
				} catch (Throwable t) {
					try {
						// la classe est deja presente alors on assai de la
						// reloader sans la definir
						c = loadClass(name);
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
					}
				}

			}

		}

		if (!classList.contains(c))
			classList.add(c);
		return c;
	}

	/**
	 * retourne la liste des classe lues
	 * 
	 * @return Vector<Class<?>>
	 */
	public List<Class<?>> getClassList() {
		return classList.size() > 0 ? classList : makeJarClassList();
	}

	/**
	 * recupere le manifest
	 * 
	 * @return
	 */
	public Manifest getManifest() {
		return manifest;
	}

	/**
	 * recupere la valeur d'un attribut d'un jar
	 * 
	 * @param manifestAttribute
	 *            l'attribut dont la valeur doit etre retourne
	 * @return la valeur
	 */
	public String getManifestValue(String manifestAttribute) {
		if (manifest == null)
			return null;
		Attributes atts = manifest.getMainAttributes();
		if (atts == null)
			return null;
		return atts.getValue(manifestAttribute);
	}

	/**
	 * surcharge
	 */
	public URL getResource(String s) {
		return getResource(s, true);
	}

	public URL getResource(String s, boolean overwrite) {
		InputStream in = getResourceAsStream(s);
		try {
			byte buf[] = new byte[512];
			int lu = in.read(buf);
			File f = new File(TMPDIR + File.separatorChar
					+ new File(s).getName());
			if (!f.exists() || overwrite) {
				FileOutputStream tmp = new FileOutputStream(f);
				while (lu > -1) {
					tmp.write(buf, 0, lu);
					lu = in.read(buf);
				}
				tmp.flush();
				tmp.close();
				// System.out.println(f.getAbsolutePath());
			}
			return new URL("file:/" + f.getAbsolutePath());
			// return f.toURL();
		} catch (IOException e) {
			e.printStackTrace();
		}
		throw new NullPointerException("null InputStream");
	}

	/**
	 * surcharge
	 */
	public InputStream getResourceAsStream(String s) {
		s = s.replace("\\", "/");
		try {
			JarInputStream jin = new JarInputStream(new FileInputStream(file));
			JarEntry je = jin.getNextJarEntry();
			while (je != null) {
				String name = je.getName();
				name.replace("\\", "/");
				if (s.compareTo(name) == 0) {
					return jin;
				}
				je = jin.getNextJarEntry();
			}
			jin.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		throw new NullPointerException("null InputStream");

	}

	/**
	 * verifie si une classe herite d'une autre
	 * 
	 * @param c
	 *            la classe fille
	 * @param parent
	 *            classe parent
	 * @return est vrai si on a fille extends parent
	 */
	public boolean isExtendedBy(Class<?> c, Class<?> parent) {
		return parent == c;
	}

	/**
	 * charge le cjar
	 */
	private void load() {
		try {
			JarInputStream jin = new JarInputStream(new FileInputStream(file));
			manifest = jin.getManifest();
			/**
			 * nous voulons stocker les class dans un tableau de byte il nous
			 * faut donc recuperer la taille de la classe
			 * 
			 */

			ZipFile zf = new ZipFile(file);
			Enumeration<? extends ZipEntry> zen = zf.entries();
			ZipEntry e;
			while (zen.hasMoreElements()) {
				e = zen.nextElement();
				String name = e.getName();
				sizeOfClass.put(name.replace("\\", "/"), (int) e.getSize());

			}
			zf.close();
			/**
			 * on les affiche
			 */

			//			Enumeration<String> en = sizeOfClass.keys(); while
			//				(en.hasMoreElements()) { String s = en.nextElement();
			//				System.out.println(s + " => " + sizeOfClass.get(s)); }

			/**
			 * on fini par recup les classes
			 */
			JarEntry je = null;
			while ((je = jin.getNextJarEntry()) != null) {
				String name = je.getName().replace("\\", "/");
				int size = sizeOfClass.get(name);
				byte[] b = new byte[size];
				int byte_read = 0;

				if (manifest == null && name.equals("META-INF/MANIFEST.MF")) {
					manifest = new Manifest();
					while (byte_read != size) {
						int blu = jin.read(b, byte_read, size - byte_read);
						if (blu > 0)
							byte_read += blu;
					}
					manifest.read(new ByteArrayInputStream(b));
				} else {
					if (!name.endsWith("class"))
						continue;
					while (byte_read != size) {
						int blu = jin.read(b, byte_read, size - byte_read);
						if (blu > 0)
							byte_read += blu;
					}

					hs.put(name, b);
				}
			}// on ferme le flux
			jin.close();
			wereUnload = false;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	/**
	 * recupere la liste des classes contenues dans le jar
	 * 
	 * @return un Vector<Class<?>>
	 */
	public List<Class<?>> makeJarClassList() {
		Enumeration<String> en = hs.keys();
		Class<?> c = null;
		while (en.hasMoreElements()) {
			String s = en.nextElement();
			byte[] b = hs.get(s);
			// on degage le .class
			String name = s.substring(0, s.indexOf('.'));
			name = name.replace("/", ".");
			try {
				c = defineClass(name, b, 0, b.length);
			} catch(LinkageError e) {
				log.warning(e.getMessage());
			}
		}
		if(c != null) {
			classList.add(c);
		}
		return getClassList();
	}

	/**
	 * creer une nouvelle instance de la classe passe en argument
	 * 
	 * @param c
	 * @return Object , l'instance de la classe ou null si la classe n'as pu
	 *         etre instancie
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 */
	public Object newInstance(Class<?> c) throws InstantiationException,
	IllegalAccessException {
		Object o = c.newInstance();
		if (o == null)
			return null;
		instanceTable.put(c, o);
		return o;
	}

	/**
	 * recharge le jar
	 */
	public void unload() {
		if (instanceTable != null && !instanceTable.isEmpty()) {
			Enumeration<Class<?>> e = instanceTable.keys();
			while (e.hasMoreElements()) {
				Class<?> c = e.nextElement();
				Object o = instanceTable.get(c);
				if (o != null)
					o = null;
				instanceTable.remove(c);
			}
			gc();
		}
		if (classList != null && !classList.isEmpty()) {
			for (int i = 0; i < classList.size(); ++i) {
				Class<?> c = classList.get(i);
				if (c != null)
					c = null;
			}
			this.classList.clear();
		}
		if (hs != null) {
			hs.clear();
		}
		manifest = null;
		if (sizeOfClass != null)
			sizeOfClass.clear();
		classList = null;
		hs = null;
		sizeOfClass = null;
		gc();
		classList = new Vector<Class<?>>();
		hs = new Hashtable<String, byte[]>();
		sizeOfClass = new Hashtable<String, Integer>();
		instanceTable = new Hashtable<Class<?>, Object>();
		wereUnload = true;

	}

	/**
	 * recharge le jar
	 */
	public void reload() {
		if (!wereUnload)
			unload();
		load();

	}

	/**
	 * methode barbare pour vider le tas d'apres les conseil de twinuts
	 */
	private void gc() {
		long usedMemoryBeforeGc = getMemoryUsed();
		long usedMemory = usedMemoryBeforeGc + 1;
		int i = 0;
		while (usedMemoryBeforeGc < usedMemory && (++i) < 100) {
			r.runFinalization();
			r.gc();
			Thread.yield();
			usedMemory = usedMemoryBeforeGc;
			usedMemoryBeforeGc = getMemoryUsed();
		}

	}

	public long getMemoryUsed() {
		return r.totalMemory() - r.freeMemory();
	}

	/**
	 * appel une methode genre void coucou(void)
	 * 
	 * @param c
	 * @param inst
	 * @param methode
	 * @return
	 * @throws SecurityException
	 * @throws NoSuchMethodException
	 */
	public static boolean call2VoidMethod(Class<?> c, Object inst,
			String methode) throws SecurityException, NoSuchMethodException {
		Method m = c.getMethod(methode);
		if (m == null)
			return false;
		try {
			m.invoke(inst, new Object[] {});
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * appel une methode de la class c
	 * 
	 * @param c
	 *            la classe contenant la methode
	 * @param inst
	 *            une instance de c
	 * @param methode
	 *            la methode a appeler
	 * @param args
	 *            les arguments de la methode
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 * @throws NoSuchMethodException
	 * @throws SecurityException
	 */
	public static Object callMethode(Class<?> c, Object inst, String methode,
			Object[] args) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		Method met = c.getMethod(methode);
		return met.invoke(inst, args);

	}

	/**
	 * appeler une methode en connaissant les types des argument
	 * 
	 * @param c
	 *            la classe
	 * @param inst
	 *            une instance de classe
	 * @param method
	 *            nom de la methode
	 * @param type
	 *            type des argument
	 * @param args
	 *            arguments
	 * @return
	 * @throws SecurityException
	 * @throws NoSuchMethodException
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public static Object callTMethod(Class<?> c, Object inst, String method,
			Class<?>[] type, Object[] args) throws SecurityException,
			NoSuchMethodException, IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		Method m = c.getMethod(method, type);
		return m.invoke(inst, args);

	}

	/**
	 * appel une methode genre Object coucou(void)
	 * 
	 * @param c
	 * @param inst
	 * @param methode
	 * @return
	 * @throws IllegalArgumentException
	 * @throws SecurityException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 * @throws NoSuchMethodException
	 */
	public static Object callVoidArgMethod(Class<?> c, Object inst,
			String methode) throws IllegalArgumentException, SecurityException,
			IllegalAccessException, InvocationTargetException,
			NoSuchMethodException {
		return callMethode(c, inst, methode, new Object[] {});
	}

	/**
	 * appel un methode genre void coucou(arg)
	 * 
	 * @param c
	 * @param inst
	 * @param methode
	 * @param args
	 * @throws IllegalArgumentException
	 * @throws SecurityException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 * @throws NoSuchMethodException
	 */
	public static void callVoidMethod(Class<?> c, Object inst, String methode,
			Object[] args) throws IllegalArgumentException, SecurityException,
			IllegalAccessException, InvocationTargetException,
			NoSuchMethodException {
		callMethode(c, inst, methode, args);
	}



	/**
	 * regarde si une classe implement une interface
	 * 
	 * @param c
	 * @param interfac
	 * @return true ou false
	 */
	public static boolean isInterfacedBy(Class<?> c, Class<?> interfac) {
		Class<?>[] interfaceList = c.getInterfaces();
		for (Class<?> cc : interfaceList) {
			// on test les noms , equals test les references
			if (cc.getSimpleName().compareTo(interfac.getSimpleName()) == 0)
				return true;
		}
		return false;
	}

	/**
	 * @return the file
	 */
	public File getFile() {
		return file;
	}

	public String toString() {
		String res = "";
		for(Class<?> clazz: this.getClassList()) {
			res = clazz.getName() + "\n";
		}
		return res;
	}
}
