/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLoader
extends ClassLoader {
    private static Runtime r = Runtime.getRuntime();
    private List<Class<?>> classList = new ArrayList();
    private File file = null;
    private Hashtable<String, byte[]> hs = new Hashtable();
    private Manifest manifest = null;
    private Hashtable<String, Integer> sizeOfClass = new Hashtable();
    private boolean wereUnload = false;
    private Hashtable<Class<?>, Object> instanceTable = new Hashtable();
    private Logger log = Logger.getLogger(JarLoader.class.getCanonicalName());
    public static String TMPDIR = System.getProperty("java.io.tmpdir");

    public JarLoader(File f, ClassLoader parent) {
        super(parent);
        this.file = f;
        this.load();
    }

    public JarLoader(String s, ClassLoader parent) {
        this(new File(s), parent);
    }

    public Class<?> findJarClass(String classe) {
        if (classe == null) {
            throw new NullPointerException("impossible de rechercher une classe nulle");
        }
        Enumeration<String> en = this.hs.keys();
        Class<?> c = null;
        while (en.hasMoreElements()) {
            String s = en.nextElement();
            String ss = s.substring(0, s.indexOf(46));
            String name = ss.replace("/", ".");
            if (classe.compareTo(name) != 0) continue;
            try {
                byte[] b = this.hs.get(s);
                c = this.defineClass(name, b, 0, b.length);
            }
            catch (Throwable t) {
                try {
                    c = this.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!this.classList.contains(c)) {
            this.classList.add(c);
        }
        return c;
    }

    public List<Class<?>> getClassList() {
        return this.classList.size() > 0 ? this.classList : this.makeJarClassList();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getManifestValue(String manifestAttribute) {
        if (this.manifest == null) {
            return null;
        }
        Attributes atts = this.manifest.getMainAttributes();
        if (atts == null) {
            return null;
        }
        return atts.getValue(manifestAttribute);
    }

    @Override
    public URL getResource(String s) {
        return this.getResource(s, true);
    }

    public URL getResource(String s, boolean overwrite) {
        InputStream in = this.getResourceAsStream(s);
        try {
            byte[] buf = new byte[512];
            int lu = in.read(buf);
            File f = new File(TMPDIR + File.separatorChar + new File(s).getName());
            if (!f.exists() || overwrite) {
                FileOutputStream tmp = new FileOutputStream(f);
                while (lu > -1) {
                    tmp.write(buf, 0, lu);
                    lu = in.read(buf);
                }
                tmp.flush();
                tmp.close();
            }
            return new URL("file:/" + f.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NullPointerException("null InputStream");
        }
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        s = s.replace("\\", "/");
        try {
            JarInputStream jin = new JarInputStream(new FileInputStream(this.file));
            JarEntry je = jin.getNextJarEntry();
            while (je != null) {
                String name = je.getName();
                name.replace("\\", "/");
                if (s.compareTo(name) == 0) {
                    return jin;
                }
                je = jin.getNextJarEntry();
            }
            jin.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("null InputStream");
    }

    public boolean isExtendedBy(Class<?> c, Class<?> parent) {
        return parent == c;
    }

    private void load() {
        try {
            JarInputStream jin = new JarInputStream(new FileInputStream(this.file));
            this.manifest = jin.getManifest();
            ZipFile zf = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> zen = zf.entries();
            while (zen.hasMoreElements()) {
                ZipEntry e = zen.nextElement();
                String name = e.getName();
                this.sizeOfClass.put(name.replace("\\", "/"), (int)e.getSize());
            }
            zf.close();
            JarEntry je = null;
            while ((je = jin.getNextJarEntry()) != null) {
                int blu;
                String name = je.getName().replace("\\", "/");
                int size = this.sizeOfClass.get(name);
                byte[] b = new byte[size];
                int byte_read = 0;
                if (this.manifest == null && name.equals("META-INF/MANIFEST.MF")) {
                    this.manifest = new Manifest();
                    while (byte_read != size) {
                        blu = jin.read(b, byte_read, size - byte_read);
                        if (blu <= 0) continue;
                        byte_read += blu;
                    }
                    this.manifest.read(new ByteArrayInputStream(b));
                    continue;
                }
                if (!name.endsWith("class")) continue;
                while (byte_read != size) {
                    blu = jin.read(b, byte_read, size - byte_read);
                    if (blu <= 0) continue;
                    byte_read += blu;
                }
                this.hs.put(name, b);
            }
            jin.close();
            this.wereUnload = false;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Class<?>> makeJarClassList() {
        Enumeration<String> en = this.hs.keys();
        Class<?> c = null;
        while (en.hasMoreElements()) {
            String s = en.nextElement();
            byte[] b = this.hs.get(s);
            String name = s.substring(0, s.indexOf(46));
            name = name.replace("/", ".");
            try {
                c = this.defineClass(name, b, 0, b.length);
            }
            catch (LinkageError e) {
                this.log.warning(e.getMessage());
            }
            if (c == null) continue;
            this.classList.add(c);
        }
        return this.getClassList();
    }

    public Object newInstance(Class<?> c) throws InstantiationException, IllegalAccessException {
        Object o = c.newInstance();
        if (o == null) {
            return null;
        }
        this.instanceTable.put(c, o);
        return o;
    }

    public void unload() {
        Class<?> c;
        if (this.instanceTable != null && !this.instanceTable.isEmpty()) {
            Enumeration<Class<?>> e = this.instanceTable.keys();
            while (e.hasMoreElements()) {
                c = e.nextElement();
                Object o = this.instanceTable.get(c);
                if (o != null) {
                    o = null;
                }
                this.instanceTable.remove(c);
            }
            this.gc();
        }
        if (this.classList != null && !this.classList.isEmpty()) {
            for (int i = 0; i < this.classList.size(); ++i) {
                c = this.classList.get(i);
                if (c == null) continue;
                Object var2_3 = null;
            }
            this.classList.clear();
        }
        if (this.hs != null) {
            this.hs.clear();
        }
        this.manifest = null;
        if (this.sizeOfClass != null) {
            this.sizeOfClass.clear();
        }
        this.classList = null;
        this.hs = null;
        this.sizeOfClass = null;
        this.gc();
        this.classList = new Vector();
        this.hs = new Hashtable();
        this.sizeOfClass = new Hashtable();
        this.instanceTable = new Hashtable();
        this.wereUnload = true;
    }

    public void reload() {
        if (!this.wereUnload) {
            this.unload();
        }
        this.load();
    }

    private void gc() {
        long usedMemoryBeforeGc = this.getMemoryUsed();
        long usedMemory = usedMemoryBeforeGc + 1L;
        int i = 0;
        while (usedMemoryBeforeGc < usedMemory && ++i < 100) {
            r.runFinalization();
            r.gc();
            Thread.yield();
            usedMemory = usedMemoryBeforeGc;
            usedMemoryBeforeGc = this.getMemoryUsed();
        }
    }

    public long getMemoryUsed() {
        return r.totalMemory() - r.freeMemory();
    }

    public static boolean call2VoidMethod(Class<?> c, Object inst, String methode) throws SecurityException, NoSuchMethodException {
        Method m = c.getMethod(methode, new Class[0]);
        if (m == null) {
            return false;
        }
        try {
            m.invoke(inst, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Object callMethode(Class<?> c, Object inst, String methode, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method met = c.getMethod(methode, new Class[0]);
        return met.invoke(inst, args);
    }

    public static Object callTMethod(Class<?> c, Object inst, String method, Class<?>[] type, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = c.getMethod(method, type);
        return m.invoke(inst, args);
    }

    public static Object callVoidArgMethod(Class<?> c, Object inst, String methode) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return JarLoader.callMethode(c, inst, methode, new Object[0]);
    }

    public static void callVoidMethod(Class<?> c, Object inst, String methode, Object[] args) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        JarLoader.callMethode(c, inst, methode, args);
    }

    public static boolean isInterfacedBy(Class<?> c, Class<?> interfac) {
        Class<?>[] interfaceList;
        for (Class<?> cc : interfaceList = c.getInterfaces()) {
            if (cc.getSimpleName().compareTo(interfac.getSimpleName()) != 0) continue;
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        String res = "";
        for (Class<?> clazz : this.getClassList()) {
            res = clazz.getName() + "\n";
        }
        return res;
    }
}

