/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader;

import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.JarException;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.JarLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLoaderManager {
    private Logger log = Logger.getLogger(JarLoaderManager.class.getCanonicalName());
    private static JarLoaderManager instance = null;

    public static JarLoaderManager getInstance() {
        if (instance == null) {
            instance = new JarLoaderManager();
        }
        return instance;
    }

    private JarLoaderManager() {
    }

    public <C> List<Class<? extends C>> getClassInJar(File jarString, ClassLoader parent, Class<? extends C> class2found) throws JarException {
        ArrayList<Class<? extends C>> res = new ArrayList<Class<? extends C>>();
        if (!class2found.isInterface()) {
            throw new JarException("The class2found parameter must be an interface!!!");
        }
        List<File> orderedClasspath = this.extractJarFileFromManifest(jarString);
        List<File> jar2reload = this.jar2Reload(orderedClasspath, parent, class2found, res);
        while (jar2reload.size() > 0) {
            jar2reload = this.jar2Reload(jar2reload, parent, class2found, res);
        }
        return res;
    }

    private List<File> extractJarFileFromManifest(File jarFile) {
        Attributes attr;
        ArrayList<File> orderedClasspath = new ArrayList<File>();
        JarLoader jar = new JarLoader(jarFile, null);
        if (jar.getManifest() != null && (attr = jar.getManifest().getMainAttributes()) != null && attr.getValue("Class-Path") != null) {
            StringTokenizer st = new StringTokenizer(attr.getValue("Class-Path"), " ");
            ArrayList<String> classpath = new ArrayList<String>();
            while (st.hasMoreElements()) {
                classpath.add(jarFile.getAbsolutePath().substring(0, jarFile.getAbsolutePath().lastIndexOf(File.separatorChar) + 1) + st.nextToken());
            }
            classpath.add(0, jarFile.toString());
            for (String file : classpath) {
                orderedClasspath.add(0, new File(file));
            }
        }
        return orderedClasspath;
    }

    private <C> List<File> jar2Reload(List<File> jars, ClassLoader parent, Class<? extends C> class2found, List<Class<? extends C>> res) {
        ArrayList<File> jar2reload = new ArrayList<File>();
        for (File jar : jars) {
            try {
                parent = new JarLoader(jar, parent);
                List<Class<?>> classes = ((JarLoader)parent).makeJarClassList();
                for (Class<?> c : classes) {
                    if (c.isInterface() || !this.isClassExtendOfClass2found(c, class2found)) continue;
                    res.add(c);
                }
            }
            catch (NoClassDefFoundError e) {
                this.log.warning("Impossible to load this jar for the moment: " + jar);
                jar2reload.add(jar);
            }
        }
        return jar2reload;
    }

    private <C> boolean isClassExtendOfClass2found(Class<?> c, Class<? extends C> class2found) {
        boolean res = false;
        try {
            if (c != null) {
                if (c.getName().equals(class2found.getName())) {
                    res = true;
                } else if (c.getInterfaces() != null) {
                    Class<?> subc;
                    Class<?>[] arr$ = c.getInterfaces();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(res = this.isClassExtendOfClass2found(subc = arr$[i$], class2found)); ++i$) {
                    }
                }
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return res;
    }
}

