/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import static org.objectweb.fractal.fraclet.types.Step.CREATE;
import static org.objectweb.fractal.fraclet.types.Step.DESTROY;
import static org.objectweb.fractal.fraclet.types.Step.START;
import static org.objectweb.fractal.fraclet.types.Step.STOP;

import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component
@Membrane(controller="primitive")
public class ProviderEndpointImpl implements ProviderEndpoint {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ProviderEndpointImpl.class.getName());

	private Service service;

	/**
	 * The component.
	 */
	@Controller
	private Component component;
	
	/**
	 * Default constructor
	 * @throws CoreException
	 */
	public ProviderEndpointImpl()  {
		super();
	}

	/**
	 * Create the scope behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = CREATE)
	public void create() throws CoreException {
		log.fine("Fractal provider endpoint created: " + FractalHelper.getFractalHelper().getName(this.component));
	}

	public void init(Component fractalNode) throws CoreException {
		this.component = fractalNode;
		log.fine("Fractal provider endpoint initiated: " + FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the NodeImpl behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = START)
	public void start() throws CoreException {
		log.fine("Fractal provider endpoint started: " + this.getName());
	}

	/**
	 * Stop the NodeImpl behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = STOP)
	public void stop() throws CoreException {
		log.finest("transition stopped: " + this.getName());
	}

	/**
	 * Destroy the NodeImpl behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = DESTROY)
	public void destroy() throws CoreException {
		log.fine("Fractal provider endpoint destroyed: " + this.getName());
	}

	public Component getComponent() {
		return this.component;
	}


	public String getName() throws CoreException {
		return FractalHelper.getFractalHelper().getName(this.component);
	}

	public void setName(String name) throws CoreException {
		if(name != null)
			FractalHelper.getFractalHelper().changeName(this.component, name);
	}

	public ExternalMessage accept(ExternalMessage msg, String invokedOperation) throws CoreException {
		return this.service.execute(msg, invokedOperation);
	}
	
	public ExecutionEnvironmentTest getExecutionEnvironmentTest() throws CoreException {
		ExecutionEnvironmentTest res = null;
		try {
			Component execEnvComp = FractalHelper.getFractalHelper().getParent(this.getComponent());
			res = (ExecutionEnvironmentTest) execEnvComp.getFcInterface("service");
		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public Service getService() {
		return this.service;
	}

	public void setService(Service s) {
		this.service = s;
	}
	
	public void setLog(Logger logger) {
		this.log = logger;
	}
}

