<?xml version="1.0" encoding="UTF-8"?>
    <!--
  Dragon - SOA Governance Platform.
  Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Initial developer(s): EBM WebSourcing
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" encoding="ISO-8859-1" />
	<xsl:param name="indent-increment" select="'   '" />
	<xsl:template name="newline">
		<xsl:text disable-output-escaping="yes">
</xsl:text>
	</xsl:template>
	<xsl:template match="comment() | processing-instruction()">
		<xsl:param name="indent" select="''" />
		<xsl:call-template name="newline" />
		<xsl:value-of select="$indent" />
		<xsl:copy />
	</xsl:template>
	<xsl:template match="text()">
		<xsl:param name="indent" select="''" />
		<xsl:call-template name="newline" />
		<xsl:value-of select="$indent" />
		<xsl:value-of select="normalize-space(.)" />
	</xsl:template>
	<xsl:template match="text()[normalize-space(.)='']" />
	<xsl:template match="*">
		<xsl:param name="indent" select="''" />
		<xsl:call-template name="newline" />
		<xsl:value-of select="$indent" />
		<xsl:choose>
			<xsl:when test="count(child::*) > 0">
				<xsl:copy>
					<xsl:copy-of select="@*" />
					<xsl:apply-templates select="*|text()">
						<xsl:with-param name="indent"
							select="concat ($indent, $indent-increment)" />
					</xsl:apply-templates>
					<xsl:call-template name="newline" />
					<xsl:value-of select="$indent" />
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>