/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.util.XMLComparator;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationImpl
implements Operation {
    private static Logger log = Logger.getLogger(OperationImpl.class.getName());
    private String name;
    private String pattern;
    private List<Operation.MessageExchangeInstances> meis = new ArrayList<Operation.MessageExchangeInstances>();
    private int successfulInvocation = 0;
    private int invocationNumber = 0;
    private Service service;

    public OperationImpl() {
    }

    public OperationImpl(String string, String string2, Service service) {
        this.name = string;
        this.pattern = string2;
        this.service = service;
    }

    @Override
    public ExternalMessage execute(ExternalMessage externalMessage) throws CoreException {
        ExternalMessage externalMessage2 = null;
        Operation.MessageExchangeInstances messageExchangeInstances = null;
        log.finest("Message received: " + externalMessage.toString());
        ++this.invocationNumber;
        String string = externalMessage.toString();
        log.finest("actual msg:\n" + string);
        for (Operation.MessageExchangeInstances messageExchangeInstances2 : this.meis) {
            String string2 = messageExchangeInstances2.getIn().toString();
            log.finest("expected msg:\n" + string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(string2.getBytes());
            try {
                if (XMLComparator.compare(byteArrayInputStream, byteArrayInputStream2) != 0) continue;
                messageExchangeInstances = messageExchangeInstances2;
                break;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (messageExchangeInstances == null) {
            try {
                Assert.fail((String)("no input message corresponding to " + string + " in operation " + this.getName()));
            }
            catch (AssertionFailedError assertionFailedError) {
                throw new RuntimeException(assertionFailedError);
            }
        }
        if (messageExchangeInstances.getOut() != null) {
            log.finest("Message return: " + messageExchangeInstances.getOut().getContent());
            externalMessage2 = messageExchangeInstances.getOut();
        } else if (messageExchangeInstances.getFault() != null) {
            Operation.MessageExchangeInstances messageExchangeInstances2;
            log.finest("Fault return: " + messageExchangeInstances.getFault().getContent());
            messageExchangeInstances2 = new CoreException();
            messageExchangeInstances2.setFault((Message)messageExchangeInstances.getFault());
            throw messageExchangeInstances2;
        }
        ++this.successfulInvocation;
        return externalMessage2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setPattern(String string) {
        this.pattern = string;
    }

    @Override
    public List<Operation.MessageExchangeInstances> getMessageExchangeInstances() {
        return this.meis;
    }

    @Override
    public void setMessageExchangeInstances(List<Operation.MessageExchangeInstances> list) {
        this.meis = list;
    }

    @Override
    public void addMessageExchangeInstances(ExternalMessage externalMessage, ExternalMessage externalMessage2, ExternalMessage externalMessage3) {
        this.meis.add(new MessageExchangeInstancesImpl(externalMessage, externalMessage2, externalMessage3));
    }

    @Override
    public int getSuccessfulInvocation() {
        return this.successfulInvocation;
    }

    @Override
    public int getInvocationNumber() {
        return this.invocationNumber;
    }

    @Override
    public void clean() {
        this.successfulInvocation = 0;
        this.invocationNumber = 0;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public class MessageExchangeInstancesImpl
    implements Operation.MessageExchangeInstances {
        public ExternalMessage in;
        public ExternalMessage out;
        public ExternalMessage fault;

        public MessageExchangeInstancesImpl(ExternalMessage externalMessage, ExternalMessage externalMessage2, ExternalMessage externalMessage3) {
            this.in = externalMessage;
            this.out = externalMessage2;
            this.fault = externalMessage3;
        }

        public ExternalMessage getFault() {
            return this.fault;
        }

        public ExternalMessage getIn() {
            return this.in;
        }

        public ExternalMessage getOut() {
            return this.out;
        }

        public void setFault(ExternalMessage externalMessage) {
            this.fault = externalMessage;
        }

        public void setIn(ExternalMessage externalMessage) {
            this.in = externalMessage;
        }

        public void setOut(ExternalMessage externalMessage) {
            this.out = externalMessage;
        }
    }
}

