/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractServiceImpl implements Service {

	private static Logger log = Logger.getLogger(AbstractServiceImpl.class.getName());

	private QName name;

	private ProviderEndpoint providerEndpoint;

	private List<Operation> operations = new ArrayList<Operation>();

	public AbstractServiceImpl(ProviderEndpoint providerEndpoint) {
		this.providerEndpoint = providerEndpoint;
	}

	public QName getName() {
		return this.name;
	}

	public void setName(QName name) {
		this.name = name;
	}

	public void addOperation(Operation op) {
		this.operations.add(op);
	}

	public List<Operation> getOperations() {
		return this.operations;
	}

	public ExternalMessage execute(ExternalMessage msg, String invokedOperation) throws CoreException {
		ExternalMessage res = null;

		// found the operation
		Operation foundOperation = null;

		System.out.println("invokedOperation = " + invokedOperation);
		for (Operation operation: this.operations) {
			System.out.println("operation = " + operation.getName());
			if(invokedOperation.equals(operation.getName())) {
				foundOperation = operation;
			}
		}

		// execute the operation
		if(foundOperation == null) {
			log.severe("operation " + invokedOperation + " with message " + msg.getContent() + " not found on service " + this.getName());
			throw new RuntimeException("operation " + invokedOperation + " with message:\n " + msg + "\n not found on service " + this.getName());
		} else {
			log.finest("Execution of operation " + foundOperation.getName() + " on service " + this.getName());
			res = foundOperation.execute(msg);
		}
		return res;
	}

	public ProviderEndpoint getProviderEndpoint() {
		return this.providerEndpoint;
	}

	public void setProviderEndpoint(ProviderEndpoint pep) {
		this.providerEndpoint = pep;
	}
}
