/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.util.XMLComparator;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class OperationImpl implements Operation {

	private static Logger log = Logger.getLogger(OperationImpl.class.getName());


	private String name;

	private String pattern;

	private List<MessageExchangeInstances> meis = new ArrayList<MessageExchangeInstances>();

	private int successfulInvocation = 0;

	private int invocationNumber = 0;

	private Service service;

	public OperationImpl() {

	}

	public OperationImpl(String name, String pattern, Service service) {
		this.name = name;
		this.pattern = pattern;
		this.service = service;
	}

	public ExternalMessage execute(ExternalMessage msg) throws CoreException {
		ExternalMessage res = null;
		MessageExchangeInstances mei = null;
		//log.finest("Message received: " + msg.toString());
		this.invocationNumber++;

		String actual = null;
		String expected = null;
		log.finest("actual msg BEFORE : \n"+msg.toString()); 
		if(msg.getContent() != null) {
			actual = msg.toString();
		}

		log.finest("actual msg:\n" + actual);
		for(MessageExchangeInstances meiItem: this.meis) {

			expected = null;
			if(meiItem.getIn().getContent() != null){
				expected = meiItem.getIn().toString();
			}
			log.finest("expected msg:\n" + expected);
			
			if(actual == null && expected == null) {
				log.finest("Expected message is null ...");
				mei = meiItem;
				break;
			} else {
				log.finest("Comparison of the expected message and the actual one.");
				InputStream actualStream = new ByteArrayInputStream(actual.getBytes());
				InputStream expectedStream = new ByteArrayInputStream(expected.getBytes());
				try {

					log.fine("coucou1");
					if(XMLComparator.compare(actualStream, expectedStream) == 0) {
						mei = meiItem;
						log.fine("coucou2");
						break;
					}
				} catch (Exception e) {
					log.fine("coucou3");
					throw new RuntimeException(e);
				}	
			}
		}



		if(mei == null) {
			try {
				Assert.fail("no input message corresponding to " + actual + " in operation " + this.getName());
			} catch(AssertionFailedError e) {
				throw new RuntimeException(e);
			}
		}

		if(mei.getOut() != null) {
			log.finest("Message return: " + mei.getOut().getContent());
			res = mei.getOut();
		} else if(mei.getFault() != null) {
			log.finest("Fault return: " + mei.getFault().getContent());
			CoreException ex = new CoreException();
			ex.setFault(mei.getFault());
			throw ex;
		} 


		this.successfulInvocation++;
		return res;
	}

	public String getName() {
		return this.name;
	}

	public String getPattern() {
		return this.pattern;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPattern(String pattern) {
		this.pattern = pattern;
	}


	public List<MessageExchangeInstances> getMessageExchangeInstances() {
		return this.meis;
	}

	public void setMessageExchangeInstances(List<MessageExchangeInstances> mei) {
		this.meis = mei;
	}

	public void addMessageExchangeInstances(ExternalMessage in,
			ExternalMessage out, ExternalMessage fault) {
		this.meis.add(new MessageExchangeInstancesImpl(in, out, fault));
	}


	public class MessageExchangeInstancesImpl implements Operation.MessageExchangeInstances {

		public ExternalMessage in;

		public ExternalMessage out;

		public ExternalMessage fault;


		public MessageExchangeInstancesImpl(ExternalMessage in, ExternalMessage out, ExternalMessage fault) {
			this.in = in;
			this.out = out;
			this.fault = fault;
		}

		public ExternalMessage getFault() {
			return this.fault;
		}

		public ExternalMessage getIn() {
			return this.in;
		}

		public ExternalMessage getOut() {
			return this.out;
		}

		public void setFault(ExternalMessage msg) {
			this.fault = msg;
		}

		public void setIn(ExternalMessage msg) {
			this.in = msg;
		}

		public void setOut(ExternalMessage msg) {
			this.out = msg;
		}

	}


	public int getSuccessfulInvocation() {
		return this.successfulInvocation;
	}


	public int getInvocationNumber() {
		return invocationNumber;
	}

	public void clean() {
		successfulInvocation = 0;
		invocationNumber = 0;
	}

	public Service getService() {
		return this.service;
	}

	public void setService(Service service) {
		this.service = service;
	}
}
