/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;

import org.apache.xml.security.c14n.Canonicalizer;

/**
 * Contains utilities methods for XML operations.
 * 
 * @author alouis - EBMWebsourcing
 * @author ddesjardins - EBMWebsourcing
 * @author gblondelle - EBMWebsourcing
 * @since 1.0
 * 
 */
public final class XMLComparator {



    public static String getXMLSHA1Sign(InputStream inputStream, boolean ommitComments)
            throws Exception {
        // Create a canonicalizer
        org.apache.xml.security.Init.init();
        Canonicalizer canonicalizer = null;
        if (ommitComments) {
            canonicalizer = Canonicalizer.getInstance(Canonicalizer.ALGO_ID_C14N11_OMIT_COMMENTS);
        } else {
            canonicalizer = Canonicalizer.getInstance(Canonicalizer.ALGO_ID_C14N11_WITH_COMMENTS);
        }

        // Prettify the given xml input stream to remove unnecessary spaces and
        // tabs
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLPrettyPrinter.prettify(inputStream, byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();

        // Canonicalize the prettified xml stream
        byte[] canonBytes = canonicalizer.canonicalize(bytes);

        // Generate the SHA1 hash
        MessageDigest hash = MessageDigest.getInstance("SHA1");
        String hashString = new String(hash.digest(canonBytes));

        return hashString;
    }
    

    public static int compare(InputStream xml1, InputStream xml2) throws Exception {
        String hash1 = getXMLSHA1Sign(xml1, true);
        String hash2 = getXMLSHA1Sign(xml2, true);
        return hash1.compareTo(hash2);
    }
}
