/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.environment.test.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;

//@Scope("COMPOSITE")
//@Service(value=AbstractCompiler.class,names="service")
//@PolicySets("frascati:scaEasyPrimitive")
public class TestRegistry extends AbstractProcessDefinitionRegistry<ProcessDefinition>{

	@Override
	public ProcessDefinition getProcessDefinition(ProcessKey name) {
		return this.registry.get(name);
	}

	
	
	@Override
	public List<ProcessDefinition> getAllProcessDefinitions() {
		  return new ArrayList<ProcessDefinition>((Collection<ProcessDefinition>) this.registry.values());
	}

	@Override
	public ProcessDefinition removeProcessDefinition(ProcessKey name,
			boolean forceUninstall) throws CoreException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <D extends ProcessDefinition> boolean isCreateInstance(D def,
			InternalMessage<?> mess) throws CoreException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public List<ProcessKey> createKeys(ProcessDefinition processDefinition){
	  final List<ProcessKey> keys = new ArrayList<ProcessKey>();
	  	ProcessKey pk = new ProcessKeyImpl();
		pk.setInterface(processDefinition.getQName());
		pk.setService(processDefinition.getQName());
		pk.setEndpoint(processDefinition.getQName().getLocalPart());
	  
		keys.add(pk);
		
		this.registry.put(pk, processDefinition);
		
	  return keys;
	}
	
}
