/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.StringExpression;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.EchoBehaviour;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=EchoBehaviour.class)})
public class EchoBehaviourImpl
extends AbstractExtendedBehaviourImpl
implements EchoBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(EchoBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private StringExpression<?> message;

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        super.getInitializationContext();
        this.context.put("message", this.message);
        return this.context;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.context.put("message", map.get("message"));
        this.message = (StringExpression)map.get("message");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public String toString() {
        return "EchoActivity";
    }

    @Override
    public StringExpression<?> getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(StringExpression<?> stringExpression) {
        this.message = stringExpression;
    }

    public Node getNode() {
        return this.node;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    protected void executeOnEnded() throws CoreException {
    }

    protected void executeOnInactive() throws CoreException {
        this.log.finest("start echo behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        this.log.finest("execute echo behaviour: " + this.message);
        if (this.message != null) {
            System.out.println((String)this.message.evaluate(this.node.getExecution().getParentScope()));
        }
    }

    protected void executeOnStarted() throws CoreException {
    }
}

