/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.autoflush.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.extended.service.autoflush.api.AutoFlushMessageService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class AutoFlushMessageServiceImpl
extends AbstractServiceImpl
implements AutoFlushMessageService {
    private Logger log = Logger.getLogger(AutoFlushMessageServiceImpl.class.getName());
    private final Map<QName, List<Map<InternalMessage, ExternalContext>>> messageRegistry = Collections.synchronizedMap(new HashMap());

    public AutoFlushMessageServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            this.flushMessagesInRegistry();
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.severe("Error in auto trash service: " + exception.getMessage());
        }
    }

    @Override
    public void flushMessagesInRegistry() throws CoreException {
        this.log.finest("flush stored messages");
        ArrayList<Map<InternalMessage, ExternalContext>> arrayList = new ArrayList<Map<InternalMessage, ExternalContext>>();
        for (List<Map<InternalMessage, ExternalContext>> object : this.messageRegistry.values()) {
            arrayList.addAll(object);
        }
        this.messageRegistry.clear();
        for (Map map : arrayList) {
            for (Map.Entry entry : map.entrySet()) {
                Engine engine = this.getEngine();
                InternalMessage internalMessage = (InternalMessage)entry.getKey();
                ExternalContext externalContext = (ExternalContext)entry.getValue();
                engine.accept(internalMessage, externalContext);
            }
        }
    }

    @Override
    public void addMessagesInRegistry(InternalMessage internalMessage, ExternalContext externalContext) {
        List<Map<InternalMessage, ExternalContext>> list = this.messageRegistry.get(internalMessage.getQName());
        if (list == null) {
            list = new ArrayList<Map<InternalMessage, ExternalContext>>();
        }
        HashMap<InternalMessage, ExternalContext> hashMap = new HashMap<InternalMessage, ExternalContext>();
        hashMap.put(internalMessage, externalContext);
        list.add(hashMap);
        this.messageRegistry.put(internalMessage.getQName(), list);
    }
}

