/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ScmConnectionMustMatchSvnEntriesIfAny
extends AbstractRule {
    @Override
    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        String actualScmConnection;
        File basedir = (File)helper.evaluate("${project.basedir}");
        File svnDir = new File(basedir, ".svn");
        File svnEntriesFile = new File(svnDir, "entries");
        if (!svnEntriesFile.exists() || !svnEntriesFile.canRead()) {
            helper.getLog().info((CharSequence)".svn/entries file is not present or not readable ; rule ignored.");
            return;
        }
        String svnPath = this.grepSvnPathFromEntries(svnEntriesFile);
        if (svnPath == null) {
            return;
        }
        String expectedScmConnection = "scm:svn:" + svnPath;
        if (!expectedScmConnection.equals(actualScmConnection = String.valueOf(helper.evaluate("${project.scm.connection}")))) {
            throw new EnforcerRuleException(String.format("Wrong SCM connection '%s' ; '%s' was expected.", actualScmConnection, expectedScmConnection));
        }
    }

    private final String grepSvnPathFromEntries(File svnEntriesFile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(svnEntriesFile));
            String svnPath = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("https")) continue;
                svnPath = line;
                break;
            }
            return svnPath;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

