/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;

public class OnlyInternalSnapshotRepoIsAllowed
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        List repositories = (List)helper.evaluate("${project.repositories}");
        if (repositories != null) {
            for (Object repo : repositories) {
                RepositoryPolicy snapshotsPolicy = ((Repository)repo).getSnapshots();
                if (snapshotsPolicy != null) {
                    if (!snapshotsPolicy.isEnabled() || "http://m2proxy:8081/artifactory/libs-snapshot-local".equals(((Repository)repo).getUrl()) || "http://maven.petalslink.com/public-snapshot".equals(((Repository)repo).getUrl())) continue;
                    throw new EnforcerRuleException("Snapshot repository '" + ((Repository)repo).getName() + "' is not allowed as snapshot dependencies source. Only our internal snapshot repository is allowed: " + "http://maven.petalslink.com/public-snapshot");
                }
                throw new EnforcerRuleException("Project repository '" + ((Repository)repo).getName() + "' must define a snapshots policy.");
            }
        }
    }
}

