/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import com.ebmwebsourcing.enforcerrules.SvnSection;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class DependenciesMustConformToInternalRules
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject parentProject;
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        SvnSection svnSection = this.guessMavenProjectSvnSection(mavenProject);
        if (svnSection == SvnSection.UNKNOWN) {
            helper.getLog().warn((CharSequence)String.format("No svn section associated with project '%s'.", mavenProject.getName()));
        }
        if ((parentProject = mavenProject.getParent()) != null) {
            SvnSection parentSvnSection = this.guessMavenProjectSvnSection(parentProject);
            if (parentSvnSection == SvnSection.UNKNOWN) {
                helper.getLog().warn((CharSequence)String.format("No svn section associated with project '%s'.", parentProject.getName()));
            }
            if (!svnSection.canDependOn(parentSvnSection)) {
                throw new EnforcerRuleException(String.format("A project in '%s' cannot inherit from a project in '%s'.", new Object[]{svnSection, parentSvnSection}));
            }
        }
        for (Object o : mavenProject.getDependencies()) {
            Dependency dep = (Dependency)o;
            if (!dep.getGroupId().startsWith("com.ebmwebsourcing.")) continue;
            MavenProject dependencyMavenProject = this.findMavenProjectForDependency(helper, mavenProject, dep);
            SvnSection dependencySvnSection = this.guessMavenProjectSvnSection(dependencyMavenProject);
            helper.getLog().info((CharSequence)String.format("'%s', %s [%s] => '%s', %s [%s].", new Object[]{mavenProject.getName(), mavenProject.getScm().getConnection(), svnSection, dependencyMavenProject.getName(), dependencyMavenProject.getScm().getConnection(), dependencySvnSection}));
            if (dependencySvnSection == SvnSection.UNKNOWN) {
                helper.getLog().warn((CharSequence)String.format("No svn section associated with project '%s'.", dependencyMavenProject.getName()));
            }
            if (svnSection.canDependOn(dependencySvnSection)) continue;
            throw new EnforcerRuleException(String.format("A project in '%s' cannot depend on a project in '%s'.", new Object[]{svnSection, dependencySvnSection}));
        }
    }
}

