/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

final class VersionUtil {
    VersionUtil() {
    }

    static String getLatestSnapshotVersion(List<String> versions) throws ComponentLookupException, ExpressionEvaluationException, ArtifactMetadataRetrievalException, IOException {
        String latestSnapshotVersion = "";
        for (String version : versions) {
            if (!version.contains("-SNAPSHOT") || (version = version.replaceAll("-SNAPSHOT", "")).compareTo(latestSnapshotVersion) <= 0) continue;
            latestSnapshotVersion = version;
        }
        return latestSnapshotVersion.isEmpty() ? null : latestSnapshotVersion + "-SNAPSHOT";
    }

    public static final String findVersionInPom(File pomFile) throws Exception {
        FileInputStream is = null;
        try {
            String version;
            is = new FileInputStream(pomFile);
            DOMSource pomDom = VersionUtil.parseAsDOMSource(is);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setNamespaceContext(new MavenNamespaceContext());
            String xpathExpr = "/mvn:project/mvn:version/text()";
            Node node = (Node)xpath.evaluate(xpathExpr, pomDom.getNode(), XPathConstants.NODE);
            if (node == null) {
                throw new EnforcerRuleException(String.format("Cannot resolve xpath '%s' on POM file '%s'.", xpathExpr, pomFile.getAbsolutePath()));
            }
            String string = version = node.getNodeValue();
            return string;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    protected static DOMSource parseAsDOMSource(InputStream is) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            Document doc = dbf.newDocumentBuilder().parse(is);
            DOMSource domSource = new DOMSource(doc);
            return domSource;
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    private static final class MavenNamespaceContext
    implements NamespaceContext {
        private MavenNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if ("mvn".equals(prefix)) {
                return "http://maven.apache.org/POM/4.0.0";
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if ("http://maven.apache.org/POM/4.0.0".equals(namespaceURI)) {
                return "mvn";
            }
            return null;
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            if ("http://maven.apache.org/POM/4.0.0".equals(namespaceURI)) {
                return Collections.singletonList("mvn").iterator();
            }
            return null;
        }
    }
}

