/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.to;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.bpmndiagram.business.domain.to.Constants.CPatCategory;
import com.ebmwebsourcing.bpmndiagram.business.domain.to.Constants.VOphase;


//import org.ow2.synapse.business.domain.eventEditor.Event;

/**
 * This class is used to get all public informations about an user <br />
 * This class shouldn't be persisted
 * 
 * @author mcarpentier
 * 
 */
public class CPat implements Serializable {

    private static final long serialVersionUID = -4217847504186801919L;

    private String id;

    /** entity details* */
    private String name;
    
    private CPatCategory category;
    
    private String problem;
    
    private VOphase phase;
    
    private String appliArea;
    
    private Set<Lane> role = new HashSet<Lane>();
    private Set<FlowNode> solution = new HashSet<FlowNode>();
    private Set<Tag> tag = new HashSet<Tag>();

    private Set<Pool> participant = new HashSet<Pool>();

    private String preCondition;
    private String postCondition;

    private String exception;

	private BPELConfiguration bpelConf;

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    public CPatCategory getCategory() {
        return category;
    }
    
    public String getProblem() {
        return problem;
    }
    
    public VOphase getPhase() {
        return phase;
    }
    
    public String getApplicationArea() {
        return appliArea;
    }
    public Set<Lane> getRole() {
        return role;
    }
    public Set<FlowNode> getSolution() {
        return solution;
    }
    public Set<Tag> getTag() {
        return tag;
    }
    public Set<Pool> getParticipant() {
        return participant;
    }
    public String getPreCondition() {
        return preCondition;
    }
    public String getPostCondition() {
        return postCondition;
    }
//    public Set<Event> getTriggers() {
//        return trigger;
//    }
    public String getException() {
        return exception;
    }
 
    public void setId(final String id) {
        this.id = id;
    }
    
    public void setName(final String name) {
        this.name = name;
    }

    public void setCategory(final CPatCategory category) {
        this.category = category;
    }
    public void setProblem(final String problem) {
        this.problem = problem;
    }
    public void setPhase(final VOphase phase) {
        this.phase = phase;
    }
    public void setAppliArea(final String appliArea) {
        this.appliArea = appliArea;
    }
    public void setRole(final Set<Lane> role) {
        this.role = role;
    }
    public void setSolution(final Set<FlowNode> solution) {
        this.solution = solution;
    }
    public void setTag(final Set<Tag> tag) {
        this.tag = tag;
    }
    public void setParticipant(final Set<Pool> participant) {
        this.participant = participant;
    }
    public void setPreCondition(final String preCondition) {
        this.preCondition = preCondition;
    }
    public void setPostCondition(final String postCondition) {
        this.postCondition = postCondition;
    }
    
    
    public void addParticipant(Pool pool){
    	this.participant.add(pool);
    }
    
    public void addRole(Lane lane){
    	this.role.add(lane);
    }
    
    public void addSolution(FlowNode flowNode){
    	this.solution.add(flowNode);
    }
    
//    public void setTriggers(final Set<Event> trigger) {
//        this.trigger = trigger;
//    }
    public void setException(final String exception) {
        this.exception = exception;
    }

	public void setBPELconfiguration(BPELConfiguration bpelConf) {
		this.bpelConf = bpelConf;
	}
	
	public BPELConfiguration getBPELconfiguration() {
		return bpelConf;
	}
	
	
	
	
}
