/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1;



import java.util.ArrayList;

//import com.allen_sauer.gwt.log.client.Log;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity.TaskElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.comment.CommentElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.connector.AssociationUnidirectional;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.connector.ConditionalSequenceFlow;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.connector.MessageFlow;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.connector.SequenceFlow;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data.DataObjectElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data.DataOutputElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.end.EndMessageElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.end.EndNoneElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.intermediate.IntermediateThrowingMessageElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.intermediate.IntermediateCatchingMessageElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.start.StartTopLevelConditionalElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.start.StartTopLevelMessageElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.start.StartTopLevelNoneElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.FlowNodeElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway.ExclusiveGatewayElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway.InclusiveGatewayElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway.ParallelGatewayElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.LaneElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.LaneListener;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.LaneListenerAdapter;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.PoolElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.PoolListener;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.PoolListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.GroupElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.DiagramPanel;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.Connectable;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.MagnetDisposition;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramGroupElementListener;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramGroupElementListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramPanelListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.Selectable;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.j4g.client.api.F;


/**
 * Only for tests
 * @author nfleury
 *
 */
@SuppressWarnings("deprecation")
public class Application implements EntryPoint {

	int i = 4;
	
	public void onModuleLoad() {
		 
//		 Log.setUncaughtExceptionHandler();
		
		 
		 
		 
		 DeferredCommand.addCommand(new Command(){
			 
			 public void execute() {
				 
				 loadDiagram();
				 
				
			}
			 
		 });
		 
		 
		 

	     
	     
	  }
	

	private void loadDiagram(){
		
		
		
		
		 
		 
		 
		 RootPanel root = RootPanel.get();  
		  

	     
	     DiagramPanel diagramPanel = new DiagramPanel(1300, 1000);
	     diagramPanel.getElement().setId("mainPanel");
	     root.add(diagramPanel,10,10);
	     


	     
	     final Label l = new Label();
	     l.getElement().setId("label");


	     
	     
	     final TaskElement task1 							= new TaskElement("task1","task",635,280);
	     final TaskElement task2 							= new TaskElement("task2","task",830,280);
	     
	     
	     final GroupElement group 							= new GroupElement("group1",610,30);
	     
	     StartTopLevelMessageElement	startTopLevel	 	= new StartTopLevelMessageElement("startMessage","startMessage",100,300);
	     
	     IntermediateCatchingMessageElement intermediateCatchinMessage = new IntermediateCatchingMessageElement("intermediateCatchingMessage","intermediateCatchingMessage",100,350);

	     IntermediateThrowingMessageElement endThrowingMessage 		= new IntermediateThrowingMessageElement("endThrowingMessage","endThrowingMessage",100,400);
	     //	     final GroupElement group2 							= new GroupElement("group2",100,300);
	     EndMessageElement		endMessage					= new EndMessageElement("endMessage","endMessage",100,450);

	     final StartTopLevelNoneElement	startnone			= new StartTopLevelNoneElement("startNone","startNone",100,550);
	     final EndNoneElement	endNone						= new EndNoneElement("endNone","endNone",100,600);
	     
	     final StartTopLevelConditionalElement	startConditional = new StartTopLevelConditionalElement("startConditional","startConditional",100,500);
	     
	     final ParallelGatewayElement	parallelGateway		= new ParallelGatewayElement("parallelGateway","parallelGateway",279,290);
	     final InclusiveGatewayElement	inclusiveGateway	= new InclusiveGatewayElement("inclusiveGateway","inclusiveGateway",279,350);
	     final ExclusiveGatewayElement	exclusiveGateway	= new ExclusiveGatewayElement("exclusiveGateway","exclusiveGateway",279,400);
	     
	     final DataObjectElement dataObject					= new DataObjectElement("dataObject","dataObject",430,500);
	     
	     Connectable gc = new Connectable(parallelGateway,MagnetDisposition.Middles);
	     
	     Connectable tc = new Connectable(task1);
	     
	     Connectable tc2 = new Connectable(task2);
	     
	     //Connectable startNoneConnectable = new Connectable(startnone);
//	     Connectable endNoneConnectable	  = new Connectable(endNone);
	     Connectable dataObjectConnectable= new Connectable(dataObject);
	     
	     root.add(l);
	     
	     PoolElement pool1 = new PoolElement("pool1","Pool",100,30);
	     //PoolElement pool2 = new PoolElement("pool2","",620,30);
	     
	     
	     pool1.setHeight(200);
	     
	     LaneElement lane1 = new LaneElement("Lane1"); 

	     pool1.addLane(lane1);
	     lane1.setWidth(800);
	     
//	     final PoolElement pool2 = new PoolElement("Pool2",300,30);
	     pool1.addLane(new LaneElement("Lane2"));
	     
	     diagramPanel.add(task1);
	     diagramPanel.add(task2);
	     
	     diagramPanel.add(pool1);
//	     diagramPanel.add(pool2);

	     
//	     diagramPanel.add(group);
//	     diagramPanel.add(group2);
	     
	     diagramPanel.add(parallelGateway);
	     diagramPanel.add(inclusiveGateway);
	     diagramPanel.add(exclusiveGateway);
	     
	     diagramPanel.add(startTopLevel);
	     diagramPanel.add(intermediateCatchinMessage);
	     diagramPanel.add(endThrowingMessage);
	     diagramPanel.add(endMessage);
	     diagramPanel.add(startConditional);
	     diagramPanel.add(startnone);
	     diagramPanel.add(endNone);
	     diagramPanel.add(dataObject);

	     SequenceFlow sequenceFlow = new SequenceFlow(DOM.createUniqueId(),540,350);


	     sequenceFlow.connect(tc, gc);
	     
	     diagramPanel.add(sequenceFlow);

	     
	     MessageFlow messageFlow  = new MessageFlow("MessageFlow",640,350);
	     
	     messageFlow.connect(tc, tc2);
	     
	     diagramPanel.add(messageFlow,1024,328);
	     
	     
	     AssociationUnidirectional au = new AssociationUnidirectional(DOM.createUniqueId(),740,350);
	     
	     au.connect(tc, dataObjectConnectable);
	     
	     diagramPanel.add(au);
	     
	     ConditionalSequenceFlow cf = new ConditionalSequenceFlow(DOM.createUniqueId(),840,350);
	     
	     cf.connect(tc2, tc);
	     
	     diagramPanel.add(cf);
	     
	     
	    
	     
	     
	     
	     diagramPanel.getJqueryObject().mousemove(new F(){
	    	 
	    	 public void f(Event event) {
	    		 
	    		 l.setText("x:"+event.getClientX()+"y:"+event.getClientY());
	    		
	    	}
	    	 
	     });
	     

//	     Button btn = new Button();
//	     btn.setText("Add a lane dynamicaly");
//	     
//	     btn.addClickListener(new ClickListener(){
//	    	 public void onClick(Widget arg0) {
//	    		 
////	    		pool2.addLane(new LaneElement("Lane"+i));
////	    		 i++;
////	    		 
//	    		 task1.setLabel("mytext");
//	    	
//	    		 
//	    	}
//	     });
	     
	 
	     //root.add(btn);
	     
	     
		CommentElement comment = new CommentElement("plop", "Comment", 500, 500);
		diagramPanel.add(comment);

		new Connectable(comment);
		
		
		pool1.addListener(new PoolListenerAdapter(){
			@Override
			public void onReceiveLane(LaneElement receivedlane) {

				super.onReceiveLane(receivedlane);
			}
			
			@Override
			public void onRemoveLane(LaneElement removedlane) {

				super.onRemoveLane(removedlane);
			}
			
		});

		
		
		lane1.addListener(new LaneListenerAdapter(){
			@Override
			public void onReceiveFlowNode(FlowNodeElement receivedFlowNode,
					int x, int y) {

	
			}
			
			@Override
			public void onFlowNodeOut(FlowNodeElement receivedFlowNode,int x, int y) {

	
			}
		});
//		
		TaskElement t = new TaskElement("azerty","plop", 456,625);
		new Connectable(t);
		diagramPanel.add(t);

	}


}
