/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity;

import java.util.List;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.HasActivityMarkersHandlers;



/**
 * This interface contains all methods activities (as in BPMN) must implement.
 * At the moment only TaskElement is implemented and is the only class that implements this interface
 * @author enhan
 *
 */
public interface Activity extends HasActivityMarkersHandlers{
	
	public enum ActivityMarkerGraphic{
		SUBPROCESS_EXPAND,
		SUBPROCESS_COLLAPSE,
		LOOP,
		PARALLEL,
		SEQUENCIAL,
		AD_HOC,
		COMPENSATION	
	}
	
	public void setActivityMarkerActivated(ActivityMarkerGraphic m, boolean enable);
	public boolean isActivityMarkerActivated(ActivityMarkerGraphic m) ;
	public List<ActivityMarkerGraphic> getActivityMarkersActivated() ;
}

