/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.HasNameHandlers;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.NameEvent;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.NameHandler;
import com.ebmwebsourcing.gwt.raphael.client.core.Path;
import com.ebmwebsourcing.gwt.raphael.client.core.Text;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramComplexElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.Selectable;
import com.ebmwebsourcing.gwt.raphael.client.diagram.type.DiagramElementType;
import com.google.gwt.event.shared.HandlerRegistration;

public abstract class AbstractDataElement extends DiagramComplexElement
		implements Selectable, HasNameHandlers {

	private DiagramElement label;
	private String labelTxt;

	public AbstractDataElement(String elementLabel, String path, String id,
			int x, int y, DiagramElementType type) {
		super(new Path(id, path, x, y), type);

		this.label = new DiagramElement(new Text(id + "-label", elementLabel,
				50, 45));

		this.addDiagramElement(label, 15, 55, true);

		isDraggable(true);

	}

	@Override
	protected void onLoad() {
		super.onLoad();

		// this.getSvgElement().attr("stroke-width", "0.5");
		this.getSvgElement().attr("fill", "black");

		this.label.getSvgElement().attr("font-size", "12");
		this.label.getSvgElement().attr("font-weight", "5");
	}

	public void isDeselected() {

		this.setBorderColor("black");

	}

	public void isSelected() {
		this.setBorderColor("red");

	}

	public void setLabel(String label) {
		this.labelTxt = label;

		this.label.getSvgElement().attr("text", label);
	}

	public String getLabel() {
		return this.labelTxt;
	}

	public HandlerRegistration addNameHandler(NameHandler handler) {
		return addHandler(handler, NameEvent.getType());
	}
	
	

}
