/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.HasNameHandlers;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.NameEvent;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.NameHandler;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane.LaneElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget.ContextMenu;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget.PopupEditor;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget.PopupTextLineEditor;
import com.ebmwebsourcing.gwt.raphael.client.core.SVGElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.Connectable;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramComplexElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElementChildData;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.Selectable;
import com.ebmwebsourcing.gwt.raphael.client.diagram.type.DiagramElementType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PopupPanel.PositionCallback;

/**
 * 
 * @author nfleury
 *
 */
public abstract class FlowNodeElement extends DiagramComplexElement implements Selectable, HasNameHandlers, HasClickHandlers, CloseHandler<PopupPanel>, HasDoubleClickHandlers{

	protected DiagramElement label;
	private String labelTxt;

	private LaneElement parentLane;
	
	private ContextMenu myContextMenu;
	private PopupEditor<String> labelEditor;
	protected Connectable connectable;
	
	public FlowNodeElement(SVGElement svgElement, DiagramElementType type) {
		super(svgElement, type);
		setupContextMenuBasic();
		init();
	}

	public Connectable getConnectable() {
		return connectable;
	}

	private void setupContextMenuBasic() {
		myContextMenu = new ContextMenu();

		// adding standard commands
		
		MenuItem rename = new MenuItem("Rename", new Command(){
			public void execute() {
				showNameEditor();
			}
		});
		
		myContextMenu.addItem(rename);
		
		MenuItem remove = new MenuItem("Remove", new Command() {
			
			public void execute() {
				remove();
			}
		});
		
		myContextMenu.addItem(remove);
		
		setupContextMenu(myContextMenu);
		
		addContextMenuHandler(new ContextMenuHandler() {
			
			public void onContextMenu(ContextMenuEvent event) {
				event.preventDefault();
				int x =event.getNativeEvent().getClientX();
				int y = event.getNativeEvent().getClientY();
				myContextMenu.show();
				myContextMenu.setPopupPosition(x, y);
			}
		});

	}

	// re-implement this in subclasses
	protected void setupContextMenu(ContextMenu menu){
		
	}
	
	protected final ContextMenu getContextMenu(){
		return myContextMenu;
	}

	public FlowNodeElement(SVGElement svgElement) {
		super(svgElement);
		setupContextMenuBasic();
		init();
	}
	
	private void init(){
		addClickHandler(new LabelEditionManager());
		labelEditor = new PopupTextLineEditor();
		labelEditor.addCloseHandler(this);
		sinkEvents(Event.ONDBLCLICK);
		addDoubleClickHandler(new LabelEditionManager());
	}
	
	// TODO here is a default impl. Make it abstract
	protected PopupEditor<String> getLabelEditor(){
		return labelEditor;
	}
	
	public void setLabel(String label){
			this.labelTxt = label;
			this.label.getSvgElement().attr("text", label);
			
	}
	
	public String getLabel() {
		return this.labelTxt;
	}
	
	public void setParentLane(LaneElement parentLane) {
		this.parentLane = parentLane;
	}
	
	public LaneElement getParentLane() {
		return parentLane;
	}
	
	public void isDeselected() {
		
		this.setBorderColor("black");
		
	}

	public void isSelected() {
		
		this.setBorderColor("red");
		
	}

	
	@Override
	protected void onLoad() {
		super.onLoad();
		this.getJqueryObject().css("z-index","10000");
		if (label != null){
			label.setZIndex(0);
		}
	}



	@Override
	public void setZIndex(int zIndex) {
		super.setZIndex(zIndex);
		for (DiagramElementChildData child : getDiagramElementChildren()) {
			if (child.getDiagramElement() != label){
				child.getDiagramElement().getElement().getStyle().setZIndex(zIndex+1);
			}
		}
	}
	
	public void showNameEditor(){
		if (getLabelEditor() != null){
			getLabelEditor().setValue(getLabel());
			getLabelEditor().setPopupPositionAndShow(new PositionCallback() {
				
				public void setPosition(int arg0, int arg1) {
					int xElement = getElement().getAbsoluteLeft();
					int yElement = getElement().getAbsoluteTop();
					
					int xElementCenter = getElement().getClientWidth()/2 + xElement;
					int yElementCenter = getElement().getClientHeight()/2 + yElement;
					
					int xEditor = xElementCenter - arg0/2;
					int yEditor = yElementCenter - arg1/2;
					
					getLabelEditor().setPopupPosition(xEditor,yEditor);
					
				}
			});
			getLabelEditor().focusOn();
		}
	}



	public HandlerRegistration addNameHandler(NameHandler handler) {
		return addHandler(handler, NameEvent.getType());
	}
	
	private void notifyHandlers(String newName){
		NameEvent.fire(this, newName);
	}



	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addHandler(handler, ClickEvent.getType());
	}
	
	protected boolean isInsideLabelElement(int x, int y){
		return false;
	}
	
	
	public void onClose(CloseEvent<PopupPanel> arg0) {
		notifyHandlers(getLabelEditor().getValue());
	}


	
	

	public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
		return addHandler(handler, DoubleClickEvent.getType());
	}





	private class LabelEditionManager implements ClickHandler, DoubleClickHandler{

		public void onClick(ClickEvent event) {
			int x = getRelativeX(event.getNativeEvent(), getDiagramPanel().getElement());
			int y = getRelativeY(event.getNativeEvent(), getDiagramPanel().getElement());
			if (isInsideLabelElement(x, y)){
				showNameEditor();
			}
			
			
		}
		
		private int getRelativeX(NativeEvent e, Element target){
			return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() +
		      target.getOwnerDocument().getScrollLeft();

		}
		
		private int getRelativeY(NativeEvent e, Element target){
			return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
		}

		public void onDoubleClick(DoubleClickEvent event) {
			showNameEditor();
		}
	}
	
}
