/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic;

import com.google.gwt.event.shared.GwtEvent;

public class NameEvent extends GwtEvent<NameHandler> {

	private static Type<NameHandler> TYPE;

	
	private String newName;
	
	protected NameEvent(HasNameHandlers source, String newName){
		this.newName = newName;
		
	}
	
	
	public static Type<NameHandler> getType(){
		 if (TYPE == null) {
		      TYPE = new Type<NameHandler>();
		    }
		    return TYPE;
	}
	
	@Override
	public Type<NameHandler> getAssociatedType() {
		return TYPE;
	}
	
	public static void fire(HasNameHandlers source, String newName){
		if (TYPE != null){
			NameEvent ev = new NameEvent(source, newName);
			source.fireEvent(ev);
		}
	}
	

	@Override
	protected void dispatch(NameHandler handler) {
		handler.onNameChanged(this);		
	}


	public String getNewName() {
		return newName;
	}
	
}
