/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.BPMNElementsPath;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.FlowNodeElement;
import com.ebmwebsourcing.gwt.raphael.client.core.Path;
import com.ebmwebsourcing.gwt.raphael.client.core.Text;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.Connectable;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.MagnetDisposition;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;

/**
 * 
 * @author nfleury
 *
 */
public class ExclusiveGatewayElement extends FlowNodeElement{
	

	public ExclusiveGatewayElement(String id,String elementLabel,int x,int y) {
		super(new Path(id,BPMNElementsPath.GATEWAY_EXCLUSIVE,x,y),new ExclusiveGatewayType());
		
		this.label = new DiagramElement(new Text(id+"-label",elementLabel,50,35));
		
		this.addDiagramElement(label, 15, 40, true);
		
		this.isDraggable(true);
		
		this.connectable = 	new Connectable(this,MagnetDisposition.Middles);
	}
	
	

	
	@Override
	protected void onLoad() {
		super.onLoad();


		this.getSvgElement().attr("fill", "black");
		this.label.getSvgElement().attr("font-size", "12");
		this.label.getSvgElement().attr("font-weight", "5");
	}
	
}
