/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget;

import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.TextBox;

/**
 * 
 * @author enhan
 *
 */
public class PopupTextLineEditor extends PopupEditor<String> implements KeyUpHandler, ValueChangeHandler<String>{
	
	private TextBox editor;
	private String backupContent;
	
	public PopupTextLineEditor() {
		editor = new TextBox();
		setWidget(editor);
		backupContent = "";
		editor.addKeyUpHandler(this);
		editor.addValueChangeHandler(this);
	}

	public void onKeyUp(KeyUpEvent arg0) {
		if (arg0.getNativeKeyCode() == KeyCodes.KEY_ESCAPE){
			editor.setText(backupContent);
			hide();
		}
	}

	public void onValueChange(ValueChangeEvent<String> arg0) {
		hide();
	}
	
	public void setValue(String value){
		editor.setText(value);
		backupContent = value;
	}
	
	public String getValue(){
		return editor.getText();
	}
	
	public void focusOn(){
		editor.setFocus(true);
	}
	
	
	
}
